package pmon.acao.frequencia;


import java.sql.Date;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pmon.apoio.*;
import pmon.dto.FrequenciaDTO;
import pmon.model.FrequenciaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class RegistrarFrequenciaExtraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		if(perfil.intValue()!= 1){
			return "/sair.do";
		}
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
//		***************Validao
		MessageErrorFrequencia mef = new MessageErrorFrequencia();

		try{
			ValidacaoFrequencia.validaEntradaExtra(req,mef);
		}catch (Exception e) {
			req.setAttribute("erro",mef);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			e.printStackTrace();
			return "/abrirRegistrarFrequenciaExtra.do?";
		}
		//***********************************************************************
			    
		FrequenciaDTO dto = new FrequenciaDTO();
		FrequenciaModel model = new FrequenciaModel(login);
		
		dto.setChavePessoaMonitor(Integer.parseInt(req.getParameter("monitor")));
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date dtFreq = sdf.parse(req.getParameter("data"));
			dto.setData(new Date(dtFreq.getTime()));
		}
		dto.setHoraEntrada(req.getParameter("horaEntrada"));
		dto.setAutenticaEntrada("Autenticado");
		dto.setAutenticaSaida("Autenticado");
		dto.setHoraSaida(req.getParameter("horaSaida"));
		
	    model.registrarEntrada(dto);
		req.getSession().setAttribute("execucao","Pesquisar");
		req.getSession().removeAttribute("frequencia");
		return "/abreFrequencia.do";
		
	}
}
