package pmon.acao.frequencia;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pmon.dto.FrequenciaDTO;
import pmon.dto.FrequenciaPesquisaDTO;
import pmon.model.FrequenciaModel;
import acao.Acao;
import dto.LoginDTO;

public class VisualizaFrequenciaAcao implements Acao{

	
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		FrequenciaPesquisaDTO dto = new FrequenciaPesquisaDTO();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		FrequenciaModel model = new FrequenciaModel(login);
		
		dto.setChaveMonitor(new Integer(Integer.parseInt(req.getParameter("chaveMonitor"))));
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if(!req.getParameter("dataEntrada").toString().equals("")){
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("dataEntrada"));
			dto.setDataInicio(new Date(dtAtendimento.getTime()));
		}
		
		dto.setDataFinal(dto.getDataInicio());
		dto.setHoraEntrada(req.getParameter("horaEntrada"));
		
		
		Collection col = model.pesquisarFrequencia(dto);
		
	Iterator iter = col.iterator();
	FrequenciaDTO frequencia = null;
	if(iter.hasNext()) {
	 frequencia = (FrequenciaDTO) iter.next();
		
	}
		req.setAttribute("frequencia", frequencia);
		
		return "/jsp/pmon/frequencia/visualizaFrequencia.jsp";
	}

}
