package pmon.acao.monitoria;



import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;

import pmon.apoio.MessageErrorMonitoria;
import pmon.dto.MonitoriaDTO;
import pmon.model.DisciplinaModel;
import pmon.model.MonitorModel;
import acao.Acao;


public class CadastroMonitoriaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		secao.setAttribute("execucao","Cadastrar");            
	
		  MonitorModel monmodel = new MonitorModel(login);
          DisciplinaModel dismodel = new DisciplinaModel(login);
          
		   Collection monitores = monmodel.listarMonitoresAtivos();
		   Collection disciplinas = dismodel.listarDisciplinas();
		   
		   req.setAttribute("monitores", monitores);
		   req.setAttribute("disciplinas", disciplinas);
		   if(req.getAttribute("erro") == null){
				MessageErrorMonitoria mem = new MessageErrorMonitoria();
				req.setAttribute("erro",mem);
			}
			if(req.getAttribute("monitoriaErro") == null){
				MonitoriaDTO mon = new MonitoriaDTO();
				req.setAttribute("monitoriaErro",mon);
			}
		   
		return "/jsp/pmon/monitoria/cadastroMonitoria.jsp";
	}

}
