package pmon.acao.monitoria;


import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import pmon.dto.MonitoriaDTO;
import pmon.model.MonitoriaModel;
import acao.Acao;

	public class PesquisaMonitoriaSemestreAcao implements Acao{

		public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
			LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
			MonitoriaModel model = new MonitoriaModel(login);
			
			MonitoriaDTO dto1 = new MonitoriaDTO();
			dto1.setSemestreEscolhido(req.getParameter("Semestre"));
		    dto1.setAnoEscolhido(new Integer(req.getParameter("ANO")).intValue());
		    String ano = ""+dto1.getAnoEscolhido();
		    Collection monit = model.listarMonitoriaSemestreAnterior(dto1.getSemestreEscolhido(), dto1.getAnoEscolhido());
			Collection semestre = model.listarSemestre();
			Collection anos = model.listarAno();
			req.setAttribute("semestre", semestre);
			req.setAttribute("ano", anos);
			req.setAttribute("Monitorias", monit);
			req.setAttribute("semestreAtual",dto1.getSemestreEscolhido());
			req.setAttribute("anoAtual", ano);
			return "/jsp/pmon/monitoria/gerenciaMonitoria.jsp";
		}
		

	}


