package pmon.acao.monitoria;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import pmon.apoio.MessageErrorMonitoria;
import pmon.apoio.ValidacaoMonitoria;
import pmon.dto.MonitoriaDTO;
import pmon.model.MonitoriaModel;
import slave.Dominio;
import acao.Acao;

public class SalvaMonitoriaAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		MessageErrorMonitoria mem = new MessageErrorMonitoria();

		try {
			ValidacaoMonitoria.valida(req, mem);
		} catch (Exception e) {
			req.setAttribute("erro", mem);
			req.setAttribute("mensagem", Dominio.getMensagemErroEntradaDeDados());
			return "/cadastrarMonitoria.do";

		}

		MonitoriaDTO dto = new MonitoriaDTO();
		StringBuffer diaSemana = new StringBuffer();
		StringBuffer salas = new StringBuffer();
		StringBuffer horarios = new StringBuffer();

		final String msgSucesso = "Monitoria Salva com Sucesso";
		final String msgErro = "Ocorreu um erro ao gravar, por favor contate o administrador";
		dto.setChavePessoaAluno(new Integer(req.getParameter("MONITOR")).intValue());
		dto.setIdDisciplina(new Integer(req.getParameter("DISCIPLINA")).intValue());

		if (req.getParameter("DiaSemanaSegunda") != null) {
			diaSemana.append("2");
		}
		if (req.getParameter("DiaSemanaTerca") != null) {
			if (diaSemana.length() == 0)
				diaSemana.append("3");
			else
				diaSemana.append("-3");
		}
		if (req.getParameter("DiaSemanaQuarta") != null) {
			if (diaSemana.length() == 0)
				diaSemana.append("4");
			else
				diaSemana.append("-4");
		}
		if (req.getParameter("DiaSemanaQuinta") != null) {
			if (diaSemana.length() == 0)
				diaSemana.append("5");
			else
				diaSemana.append("-5");
		}
		if (req.getParameter("DiaSemanaSexta") != null) {
			if (diaSemana.length() == 0)
				diaSemana.append("6");
			else
				diaSemana.append("-6");
		}
		if (req.getParameter("DiaSemanaSabado") != null) {

			if (diaSemana.length() == 0)
				diaSemana.append("7");
			else
				diaSemana.append("-7");
		}
		dto.setDiaSemana(diaSemana.toString());
		dto.setAno(new Integer(req.getParameter("Ano")).intValue());
		dto.setSemestre(req.getParameter("Semestre"));
        dto.setCampus(req.getParameter("Campus"));
		dto.setSala1(req.getParameter("Sala1"));
		dto.setSala2(req.getParameter("Sala2"));
		dto.setSala3(req.getParameter("Sala3"));
		dto.setSala4(req.getParameter("Sala4"));

		if (dto.getSala1().toString() != "")
			salas.append(dto.getSala1());
		if (dto.getSala2().toString() != "")
			salas.append("/" + dto.getSala2());
		if (dto.getSala3().toString() != "")
			salas.append("/" + dto.getSala3());
		if (dto.getSala4().toString() != "")
			salas.append("/" + dto.getSala4());
		dto.setSala(salas.toString());

		dto.setHorarioEntrada1(req.getParameter("horarioEntrada1"));
		dto.setHorarioEntrada2(req.getParameter("horarioEntrada2"));
		dto.setHorarioEntrada3(req.getParameter("horarioEntrada3"));
		dto.setHorarioEntrada4(req.getParameter("horarioEntrada4"));

		dto.setHorarioSaida1(req.getParameter("horarioSaida1"));
		dto.setHorarioSaida2(req.getParameter("horarioSaida2"));
		dto.setHorarioSaida3(req.getParameter("horarioSaida3"));
		dto.setHorarioSaida4(req.getParameter("horarioSaida4"));

		if (dto.getHorarioEntrada1().toString() != "") {
			horarios.append(dto.getHorarioEntrada1() + "=>");
			horarios.append(dto.getHorarioSaida1());
		}

		if (dto.getHorarioEntrada2().toString() != "") {
			horarios.append("/" + dto.getHorarioEntrada2() + "=>");
			horarios.append(dto.getHorarioSaida2());
		}
		if (dto.getHorarioEntrada3().toString() != "") {
			horarios.append("/" + dto.getHorarioEntrada3() + "=>");
			horarios.append(dto.getHorarioSaida3());
		}

		if (dto.getHorarioEntrada4().toString() != "") {
			horarios.append("/" + dto.getHorarioEntrada4() + "=>");
			horarios.append(dto.getHorarioSaida4());
		}
		dto.setHorario(horarios.toString());

		

		MonitoriaModel model = new MonitoriaModel(login);
		int result = model.gravaMonitoria(dto);
		if (result == 1) {
			req.setAttribute("msg", msgSucesso);
		} else {
			req.setAttribute("msg", msgErro);
		}
		return "/jsp/pmon/monitoria/SalvaMonitoria.jsp";
	}

}