package pmon.apoio;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import dto.LoginDTO;

import pmon.dto.AtendimentoDTO;
import pmon.model.ProfessorModel;

public class ValidacaoAtendimento {
	public static void valida(HttpServletRequest req,MessageErrorAtendimento mea) throws Exception{
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		boolean erro = false;
		try {// valida duracao
			if(Integer.parseInt(req.getParameter("duracao").toString()) < 10){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mea.setMessagemErroDuracao("duracao invlida");
			erro = true;
			
		}
		
		try {//valida data
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtNascimento = sdf.parse(req.getParameter("data"));
			Date dt = new Date(dtNascimento.getTime());
		}catch (Exception e) {
			mea.setMessagemErroDataAtendimento("Data invalida ");
			erro = true;
			
		}
		try {//valida data no semestre
			String erro1 = new String(),erro2 = new String();
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			java.sql.Date dt = new java.sql.Date(dtAtendimento.getTime());
			java.sql.Date hoje = new java.sql.Date(new java.util.Date().getTime());
			/*if(Data.getSemestre(dt)!= Data.getSemestre(hoje)){//data desse semestre
				mea.setMessagemErroDataAtendimento("essa data no pertence a esse semestre" );
				throw new Exception();
			}*/
			
		}catch (Exception e) {
			
			e.printStackTrace();
			erro = true;
		}
		
		try {//valida aluno => turma 
			ProfessorModel prof = new ProfessorModel(login);
			AtendimentoDTO dto = new AtendimentoDTO();
			dto.setIdDisciplina(Integer.parseInt(req.getParameter("disciplina").toString()));
			dto.setCPAluno(Integer.parseInt(req.getParameter("aluno").toString()));
			
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			dto.setDataAtendimento(new java.sql.Date(dtAtendimento.getTime()));
			if(prof.getTurmaAluno(dto) == false){
				throw new Exception();
			}
				
			
		}catch (Exception e) {
			mea.setMessagemErroAluno("Aluno no matriculado nessa disciplina nesse semestre");
			erro = true;
		}
		
		if(erro == true){
			carregarAtendimento(req);
			throw new Exception();
		}
		
	}
	public static void validaAlteracao(HttpServletRequest req,MessageErrorAtendimento mea) throws Exception{
		boolean erro = false;
		try {// valida duracao
			if(Integer.parseInt(req.getParameter("duracao").toString()) < 10){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mea.setMessagemErroDuracao("duracao invlida");
			erro = true;
			
		}
		
		try {//valida data
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtNascimento = sdf.parse(req.getParameter("data"));
			Date dt = new Date(dtNascimento.getTime());
		}catch (Exception e) {
			mea.setMessagemErroDataAtendimento("Data invalida ");
			erro = true;
			
		}
		try {//valida data no semestre
			String erro1 = new String(),erro2 = new String();
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			java.sql.Date dt = new java.sql.Date(dtAtendimento.getTime());
			java.sql.Date hoje = new java.sql.Date(new java.util.Date().getTime());
			
		/*	if(Data.getSemestre(dt)== Data.getSemestre(hoje)){//data desse semestre
				mea.setMessagemErroDataAtendimento("essa data no pertence a esse semestre" );
				throw new Exception();
			}*/
			
		}catch (Exception e) {
			
			e.printStackTrace();
			erro = true;
		}
		
		if(erro == true){
			carregarAtendimentoAlteracao(req);
			throw new Exception();
		}
		
	}
	private static void  carregarAtendimento(HttpServletRequest req) throws ParseException{
		
		AtendimentoDTO dto = new AtendimentoDTO();
		dto.setIdDisciplina(Integer.parseInt(req.getParameter("disciplina").toString()));
		dto.setCPAluno(Integer.parseInt(req.getParameter("aluno").toString()));
		dto.setDuracao(Integer.parseInt(req.getParameter("duracao").toString()));
		dto.getParecer().setParecerMonitor(req.getParameter("parecerMonitor").toString());
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			dto.setDataAtendimento(new java.sql.Date(dtAtendimento.getTime()));
		}
		else{
			dto.setDataAtendimento(null);
		}
		if(req.getParameter("notificarProfessor")!= null){//verificar se est checado
			dto.getParecer().setNotificar('S');
		}
		else{
			dto.getParecer().setNotificar('N');
		}
		
		if(req.getParameter("presencial")!= null){//verificar se est checado
			dto.setLocalAtendimento('D');
		}
		else{
			dto.setLocalAtendimento('P');
		}
		
		req.setAttribute("atendimentoErro",dto);
	}
private static void  carregarAtendimentoAlteracao(HttpServletRequest req) throws ParseException{
		
		AtendimentoDTO dto = new AtendimentoDTO();
		dto.setNomeDisciplina(req.getParameter("disciplina").toString());
		dto.setIdConteudo(Integer.parseInt(req.getParameter("conteudo").toString()));
		dto.setNomeAluno(req.getParameter("aluno").toString());
		dto.setDuracao(Integer.parseInt(req.getParameter("duracao").toString()));
		dto.getParecer().setParecerMonitor(req.getParameter("parecerMonitor").toString());
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date dtAtendimento = sdf.parse(req.getParameter("data"));
			dto.setDataAtendimento(new java.sql.Date(dtAtendimento.getTime()));
		}
		else{
			dto.setDataAtendimento(null);
		}
		if(req.getParameter("notificarProfessor")!= null){//verificar se est checado
			dto.getParecer().setNotificar('S');
		}
		else{
			dto.getParecer().setNotificar('N');
		}
		
		if(req.getParameter("presencial")!= null){//verificar se est checado
			dto.setLocalAtendimento('D');
		}
		else{
			dto.setLocalAtendimento('P');
		}
		
		req.setAttribute("atendimentoErro",dto);
	}
	
}
