package pmon.apoio;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import dto.LoginDTO;

import pmon.dto.AtendimentoDTO;
import pmon.dto.FrequenciaDTO;
import pmon.model.MonitorModel;

public class ValidacaoFrequencia {
	public static void valida(HttpServletRequest req,MessageErrorFrequencia mef) throws Exception{
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		boolean erro = false;
		MonitorModel model = new MonitorModel(login);
		try {// senha
			String senha = req.getParameter("senha");
			dto.MonitorDTO monitor = (dto.MonitorDTO)req.getSession().getAttribute("monitor");
			//se der errado lana exception
			if(!model.Autentica(monitor.getChavePessoa().intValue(), senha)){
				throw new Exception();
			}
		}catch (Exception e) {
			mef.setMessagemErroLogin("Senha Incorreta");
			erro = true;
			
		}
		
			
		if(erro == true){
			throw new Exception();
		}
		
	}
	public static void validaEntradaExtra(HttpServletRequest req,MessageErrorFrequencia mef) throws Exception{
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		boolean erro = false;
		try {// valida monitor
			model.MonitorModel model = new model.MonitorModel(login);
			Integer chave = new Integer(req.getParameter("monitor").toString());
			if(model.buscarMonitor(chave)== null){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mef.setMensagemErroMonitor("monitor invlido");
			erro = true;
			
		}
		
		try {//valida data
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date data = sdf.parse(req.getParameter("data"));
			Date dt = new Date(data.getTime());
		}catch (Exception e) {
			mef.setMensagemErroData("Data invalida ");
			erro = true;
			
		}
		try {//valida hora
			String hora1   = req.getParameter("horaEntrada");
			String hora2  = req.getParameter("horaSaida");
			if(!validaHora(hora1) | !validaHora(hora2))
				throw new Exception();
			
			
		}catch (Exception e) {
			mef.setMensagemErroData("hora invalida ");
			erro = true;
			
		}
		
		if(erro == true){
			carregarFrequenciaExtra(req);
			throw new Exception();
		}	
	}
	private static void  carregarFrequenciaExtra(HttpServletRequest req) throws ParseException{
		
		FrequenciaDTO dto = new FrequenciaDTO();
		dto.setChavePessoaMonitor(Integer.parseInt(req.getParameter("monitor")));
		dto.setAutenticaEntrada("ENTRADA EXTRA");
		dto.setAutenticaSaida("ENTRADA EXTRA");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		if(!req.getParameter("data").toString().equals("")){
			java.util.Date data = sdf.parse(req.getParameter("data"));
			dto.setData(new java.sql.Date(data.getTime()));
		}
		else{
			dto.setData(null);
		}
		if(req.getParameter("horaEntrada").toString().equals("")){
			dto.setHoraEntrada(req.getParameter("horaEntrada"));
		}
		else{
			dto.setHoraEntrada("");
		}
		if(!req.getParameter("horaSaida").toString().equals("")){
			dto.setHoraSaida(req.getParameter("horaSaida"));
		}
		else{
			dto.setHoraSaida("");
		}
		
		req.setAttribute("frequenciaErro",dto);
		System.out.println("setou");
	}
	public static boolean validaHora(String hhmmss){
		int h,m,s;
		h= Integer.parseInt(hhmmss.substring(0, hhmmss.indexOf(':')));
		hhmmss = hhmmss.substring(hhmmss.indexOf(':')+1);
	
		m = Integer.parseInt(hhmmss.substring(0, hhmmss.indexOf(':')));
		s = Integer.parseInt(hhmmss.substring(hhmmss.indexOf(':')+1));
		
		if(h > 23  | h < 0  | m >59 | m < 0 | s > 59 | s < 0)
			return false;			
		
		return true;
	}
	
}
