package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import pmon.dto.AlunoDTO;
import dao.DAOBase;

public class AlunoDAO extends DAOBase {
	
	private static final String SQL_LIST = "select A.chavePessoa, P.nomePessoa, A.matricula, A.codigoCurso " +
			" from maiorAluno A, maiorPessoa P where A.chavePessoa = P.chavePessoa ORDER BY P.nomePessoa";
	
	
	public Collection listarAlunos() throws SQLException {
        Collection result = new ArrayList();
        Statement stm =  getConnection().createStatement();
        ResultSet rs = stm.executeQuery(SQL_LIST);
        
        while ( rs.next() ) {
        	AlunoDTO dto = new AlunoDTO();
            put(dto, rs);
            result.add(dto);
        }
        
        rs.close();
        stm.close();
        
        return result;
    }
    private void put(AlunoDTO dto, ResultSet rs) throws SQLException {
    	 dto.setNomePessoa(rs.getString("nomePessoa"));
         dto.setChavePessoa(rs.getString("chavePessoa"));
         dto.setMatricula(rs.getString("matricula"));
         dto.setCurso(rs.getInt("codigoCurso"));
    }
}
