package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import pmon.apoio.Data;
import pmon.dto.AtendimentoDTO;
import pmon.dto.AtendimentoPesquisaDTO;
import dao.DAOBase;





public class AtendimentoDao extends DAOBase {
	
	private static final String SQL_LIST = "select * from pmAtendimento ORDER BY  dtAtendimento DESC";
	private static final String SQL_BUSCAULTIMOINSERIDO = "SELECT MAX(idAtendimento) as idAtendimento FROM pmAtendimento";
	private static final String SQL_INSERT ="INSERT INTO pmAtendimento VALUES (?,?,?,?,?,?,?,?)";
	private static final String SQL_LIST2 ="select a.idAtendimento, a.duracao,a.localatender, p.nomepessoa,"+
	" pp.nomepessoa,d.nomeDisciplina, a.dtatendimento,"+
	" a.chavepessoaAluno, a.chavepessoaMonitor,t.chavepessoaprofessor"+
	" pa.parecermonitor, pa.notificar, pa.parecerprofessor"+
	" from maiorPessoa p, maiorPessoa pp, maiorPessoa ppp,"+
	" maiorTurma t, maiorTurma_Aluno ta, maiorDisciplina d,"+
	" pmAtendimento a, pmParecer pa"+
	" where a.chavePessoaAluno = p.chavePessoa"+
	" and a.chavePessoaMonitor = pp.chavePessoa"+
	" and t.chavePessoaProfessor = ppp.chavePessoa"+
	" and ta.ano = t.ano and ta.semestre = t.semestre"+
	" and ta.codigoTurma = t.codigoTurma"+
	" and ta.idDisciplina = t.idDisciplina " +
	" and year(a.dtAtendimento) = ta.ano "+
	" and a.chavePessoaAluno = ta.chavePessoaAluno"+
	" and a.idDisciplina = ta.idDisciplina"+
	" and a.idDisciplina = d.idDisciplina" ;

	private static final String SQL_BUSCAATENDIMENTOPORID ="select a.idAtendimento, a.duracao,a.localAtender, p.nomePessoa,"+
	" a.idConteudo, con.descricao,  pp.nomePessoa,d.idDisciplina,d.nomeDisciplina, ppp.nomePessoa, a.dtAtendimento,"+
	" a.chavePessoaAluno, a.chavepessoaMonitor,t.chavepessoaprofessor"+
	" FROM maiorPessoa p, maiorPessoa pp, maiorPessoa ppp,"+
	" maiorTurma t, maiorTurma_Aluno ta, maiorDisciplina d,"+
	" pmAtendimento a, maiorConteudo con"+
	" WHERE a.chavePessoaAluno = p.chavePessoa"+
	" and a.chavePessoaMonitor = pp.chavePessoa " +
	" and year(a.dtAtendimento) = ta.ano "+	
	" and t.chavePessoaProfessor = ppp.chavePessoa"+
	" and ta.ano = t.ano and ta.semestre = t.semestre"+
	" and ta.codigoTurma = t.codigoTurma"+
	" and ta.idDisciplina = t.idDisciplina"+
	" and a.chavePessoaAluno = ta.chavePessoaAluno"+
	" and a.idDisciplina = ta.idDisciplina"+
	" and a.idDisciplina = d.idDisciplina" +
	" and a.idConteudo = con.idConteudo " +
	" and if(month(a.dtAtendimento) < 7, 1, if((day(a.dtAtendimento) < 15 and month(a.dtAtendimento) = 7),1,2)) = t.semestre" +
	" and a.idAtendimento = ?";
	private static final String SQL_BUSCAPARECERPORID =
		"select pa.parecerMonitor, pa.notificar, pa.parecerProfessor"+
		" FROM pmAtendimento a"+
		", pmParecer pa"+
		" WHERE a.idAtendimento = pa.idAtendimento" +
		" and a.idAtendimento = ?";

	private static final String SQL_EXCLUIRATENDIMENTO = "DELETE FROM pmAtendimento WHERE idAtendimento = ?";
	private static final String SQL_ALTERARATENDIMENTO = "UPDATE pmAtendimento" +
	" set duracao = ?, " +
	" dtAtendimento = ?," +
	" localAtender = ?" +
	" WHERE idAtendimento = ?";

	private static final String SQL_ALTERAR_STATUS_PARECER = "UPDATE pmParecer p SET notificar = ? where p.`idAtendimento` = ?";
	
	private static final String SQL_TEM_NOTIFICACAO = "select count(*) as qtd, t.chavepessoaprofessor " +
	" FROM maiorPessoa p, maiorPessoa pp, maiorPessoa ppp,  maiorTurma t, maiorTurma_Aluno ta, maiorDisciplina d, " +
	" pmAtendimento a, maiorConteudo con, pmParecer pr " +
	" WHERE a.chavePessoaAluno = p.chavePessoa and a.chavePessoaMonitor = pp.chavePessoa " +
	" and year(a.dtAtendimento) = ta.ano and t.chavePessoaProfessor = ppp.chavePessoa " +
	" and ta.ano = t.ano and ta.semestre = t.semestre and ta.codigoTurma = t.codigoTurma" +
	" and ta.idDisciplina = t.idDisciplina and a.chavePessoaAluno = ta.chavePessoaAluno" +
	" and a.idDisciplina = ta.idDisciplina and a.idDisciplina = d.idDisciplina" +
	" and a.idConteudo = con.idConteudo and a.idAtendimento = pr.idAtendimento " +
	" and pr.notificar = 'S'  and t.chavePessoaProfessor = ? group by t.chavePessoaProfessor";
	
	private static final String SQL_TEM_NOTIFICACAO_MONITOR = "select count(*) as qtd, a.chavepessoaMonitor " +
			" FROM maiorPessoa pp, pmAtendimento a, pmParecer pr " +
			" WHERE a.chavePessoaMonitor = pp.chavePessoa " +
			" and a.idAtendimento = pr.idAtendimento " +
			" and pr.notificar = 'R'  and a.chavePessoaMonitor = ? group by a.chavePessoaMonitor";
	
	public Collection listar() throws SQLException {
		Collection result = new ArrayList();
		Statement stm =  getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LIST);

		while ( rs.next() ) {
			AtendimentoDTO dto = new AtendimentoDTO();
			put(dto, rs);
			result.add(dto);
		}

		rs.close();
		stm.close();

		return result;
	}
	public Collection pesquisar(AtendimentoPesquisaDTO dto) throws SQLException {
		final StringBuffer SQL_PESQ = new StringBuffer("SELECT a.idAtendimento, a.duracao,a.localAtender, p.nomePessoa,");
		SQL_PESQ.append(" a.idConteudo, pp.nomePessoa,d.nomeDisciplina, ppp.nomePessoa, a.dtAtendimento,");
		SQL_PESQ.append(" a.chavePessoaAluno, a.chavePessoaMonitor,t.chavePessoaProfessor");
		SQL_PESQ.append(" FROM maiorPessoa p, maiorPessoa pp, maiorPessoa ppp,  ");
		SQL_PESQ.append(" maiorTurma t, maiorTurma_Aluno ta, maiorDisciplina d, pmAtendimento a" );
		if(!dto.getNotificado().equals("3")){ // se notifica��o != TODOS
			SQL_PESQ.append(", pmParecer prc");
		}
		SQL_PESQ.append(" WHERE a.chavePessoaAluno = p.chavePessoa");

		if(!dto.getAluno().equals("Todos")){ // nome do aluno
			SQL_PESQ.append(" AND p.nomePessoa like '"+dto.getAluno()+"%'");
		}
		if(!dto.getMonitor().equals("Todos")) {// chave do monitor
			SQL_PESQ.append(" AND a.chavePessoaMonitor = '"+dto.getMonitor()+"'");
		}
		SQL_PESQ.append(" AND a.chavePessoaMonitor = pp.chavePessoa");
		if(!dto.getProfessor().equals("Todos")){ // chave do professor
			SQL_PESQ.append(" AND t.chavePessoaProfessor = '"+dto.getProfessor()+"'");
		}
		SQL_PESQ.append(" AND t.chavePessoaProfessor = ppp.chavePessoa");
		SQL_PESQ.append(" AND ta.ano = t.ano and ta.semestre = t.semestre");
		SQL_PESQ.append(" AND ta.codigoTurma = t.codigoTurma");
		if(!dto.getDisciplina().equals("Todas")){ // id da disciplina
			SQL_PESQ.append(" AND d.idDisciplina = '"+dto.getDisciplina()+"'");
		}
		SQL_PESQ.append(" AND ta.idDisciplina = t.idDisciplina");
		SQL_PESQ.append(" AND a.chavePessoaAluno = ta.chavePessoaAluno");
		SQL_PESQ.append(" AND a.idDisciplina = ta.idDisciplina");
		SQL_PESQ.append(" AND a.idDisciplina = d.idDisciplina" );
		SQL_PESQ.append(" and year(a.dtAtendimento) = ta.ano ");
		SQL_PESQ.append(" and if(month(a.dtAtendimento) < 7, 1,2) = t.semestre ");
		
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND a.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND a.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );

		if(dto.getNotificado().equals("1")){  // (PARECER) se notificacao == SEM NOTIFICACAO
			SQL_PESQ.append(" AND prc.idAtendimento = a.idAtendimento" );
			SQL_PESQ.append(" AND prc.notificar = 'N'" );
		}else{
			if(dto.getNotificado().equals("2")){ // (PARECER) se notificacao == COM NOTIFICACAO 
				SQL_PESQ.append(" AND prc.idAtendimento = a.idAtendimento" );
				SQL_PESQ.append(" AND prc.notificar != 'N'");
			}
			else{
				if(dto.getNotificado().equals("4")){ // (PARECER) se notificacao == COM ORIENTACACAO (respondido pelo professor) 
					SQL_PESQ.append(" AND prc.idAtendimento = a.idAtendimento" );
					SQL_PESQ.append(" AND (prc.notificar = 'R' OR prc.notificar = 'M') " +
							" AND (a.chavePessoaMonitor = " + dto.getMonitorPesq() +
							"      OR exists (SELECT B.idDisciplina " +
							"      FROM  maiorMonitor B " +
							"      WHERE B.idDisciplina = a.idDisciplina AND B.chavePessoa = " + dto.getMonitorPesq() +
							"     and B.dtSAida is null ) " +
							" )");
					
				}	

			}
//			 se notificacao == TOODOS, n�o faz nada
		}
		if(dto.getPresencial().equals("1")){   //presencial
			SQL_PESQ.append(" AND a.localAtender = 'P'" );
		}else{
			if(dto.getPresencial().equals("2")){  // a distancia
				SQL_PESQ.append(" AND a.localAtender = 'D'");
			}	
		}

		SQL_PESQ.append(" ORDER BY a.dtAtendimento DESC");
		
//		System.out.println("PESQUISA :" + SQL_PESQ.toString());
		Collection result = new ArrayList();
		Statement stm =  getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_PESQ.toString());

		while ( rs.next() ) {
			AtendimentoDTO dto2 = new AtendimentoDTO();
			//	System.out.println("foi p put");
			put(dto2, rs);
			result.add(dto2);
		}

		rs.close();
		stm.close();

		return result;
	}
	public Collection listar(String chavePessoaMonitor) throws SQLException  {
		final String SQL_LIST_MONITOR = "select * from pmAtendimento where chavePessoaMonitor = "+chavePessoaMonitor+" order by dtAtendimento";

		Collection result = new ArrayList();
		Statement stm;

		stm = getConnection().createStatement();

		ResultSet rs = stm.executeQuery(SQL_LIST_MONITOR);
		while ( rs.next() ) {
			AtendimentoDTO dto = new AtendimentoDTO();
			put(dto, rs);
			result.add(dto);
		}

		rs.close();
		stm.close();


		return result;

	}
	private void put(AtendimentoDTO dto, ResultSet rs) throws SQLException {

		dto.setDataAtendimento(rs.getDate("dtAtendimento"));
		dto.setDuracao(rs.getInt("Duracao"));
		dto.setLocalAtendimento(rs.getString("localAtender").charAt(0));
		dto.setCPAluno(rs.getInt("chavePessoaAluno"));
		dto.setCPMonitor(rs.getInt("chavePessoaMonitor"));
		dto.setIdAtendimento(rs.getInt("idAtendimento"));
		dto.setNomeProfessor(rs.getString("ppp.nomepessoa"));
		dto.setNomeAluno(rs.getString("p.nomepessoa"));
		dto.setNomeMonitor(rs.getString("pp.nomepessoa"));
		dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
		dto.setIdConteudo(rs.getInt("idConteudo"));

	}
	private void putComParecer(AtendimentoDTO dto, ResultSet rs, ResultSet rs2) throws SQLException {

		dto.setDataAtendimento(rs.getDate("dtAtendimento"));
		dto.setDuracao(rs.getInt("Duracao"));
		dto.setLocalAtendimento(rs.getString("localAtender").charAt(0));
		dto.setCPAluno(rs.getInt("chavePessoaAluno"));
		dto.setCPMonitor(rs.getInt("chavePessoaMonitor"));
		dto.setCpProfessor(rs.getInt("chavePessoaProfessor"));
		dto.setIdAtendimento(rs.getInt("idAtendimento"));
		dto.setNomeProfessor(rs.getString("ppp.nomepessoa"));
		dto.setNomeAluno(rs.getString("p.nomepessoa"));
		dto.setNomeMonitor(rs.getString("pp.nomepessoa"));
		dto.setIdDisciplina(rs.getInt("idDisciplina"));
		dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
		dto.setIdConteudo(rs.getInt("idConteudo"));
		if(rs2.next()){
			dto.getParecer().setParecerMonitor(rs2.getString("parecerMonitor"));
			dto.getParecer().setParecerProfessor(rs2.getString("parecerProfessor"));
			dto.getParecer().setNotificar(rs2.getString("notificar").charAt(0));
		}else{
			dto.getParecer().setParecerMonitor("");
			dto.getParecer().setParecerProfessor("");
			dto.getParecer().setNotificar('N');
		}

	}


	public void alterarAtendimento(AtendimentoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARATENDIMENTO);

		ps.setInt(1,dto.getDuracao());
		ps.setDate(2,dto.getDataAtendimento());
		ps.setString(3,""+dto.getLocalAtendimento());//n�o existe set Char
		ps.setInt(4,dto.getIdAtendimento());

		ps.executeUpdate();
		ps.close();	}

	public void cadastrarAtendimento(AtendimentoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT);
		ps.setInt(1,0);//zero para autoincremento do Mysql
		ps.setInt(2,dto.getCPAluno());
		ps.setInt(3,dto.getCPMonitor());
		ps.setInt(4,dto.getIdDisciplina());
		ps.setInt(5,dto.getDuracao());
		ps.setString(6,""+dto.getLocalAtendimento());//n�o existe set Char
		ps.setDate(7,dto.getDataAtendimento());
		ps.setString(8,""+dto.getIdConteudo());//n�o existe set Char

		ps.executeUpdate();
		ps.close();
	}

	public void excluirAtendimento(int idAtendimento)throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRATENDIMENTO);
		ps.setInt(1,idAtendimento);


		ps.executeUpdate();
		ps.close();


	}
	public AtendimentoDTO buscaAtendimentoPorId(int idAtendimento) throws SQLException{
		AtendimentoDTO dto = new AtendimentoDTO();
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAATENDIMENTOPORID);
		ps.setInt(1,idAtendimento);

		ResultSet rs = ps.executeQuery();
//System.out.println("sql : " + ps.toString());
		PreparedStatement ps2 = getConnection().prepareStatement(SQL_BUSCAPARECERPORID);
		ps2.setInt(1,idAtendimento);
		ResultSet rs2 = ps2.executeQuery();


		if(rs.next()){
			putComParecer(dto,rs, rs2);
			dto.setConteudo(rs.getString("descricao")); // para inserir a descri��o do conte�do. coloquei separado para n�o atrapalhar os demais
		}
		//System.out.println(dto.getParecer().getParecerProfessor());
		ps.close();
		return dto;
	}
	public int buscaUltimoInserido() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAULTIMOINSERIDO);
		rs.next();
		int ultimoInserido = rs.getInt("idAtendimento");
		return ultimoInserido;
	}
	/**
	 * @param c
	 * @param idAtendimento 
	 * @throws SQLException 
	 */
	public void alteraStatusParecer(char status, int idAtendimento) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAR_STATUS_PARECER);
		ps.setString(1,status+"");
		ps.setInt(2,idAtendimento);
		ps.executeUpdate();
		ps.close();
		
	}
	/**
	 * @param chavePessoaProfessor
	 * @return
	 * @throws SQLException 
	 */
	public int temParecerComNotificacaoNaoLido(int chavePessoaProfessor) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_TEM_NOTIFICACAO);
		ps.setInt(1,chavePessoaProfessor);
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			return rs.getInt("qtd");
		
		return 0;
	}
	/**
	 * @param chavePessoaMonitor
	 * @return
	 * @throws SQLException 
	 */
	public int temParecerComNotificacaoNaoLidoMonitor(int chavePessoaMonitor) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_TEM_NOTIFICACAO_MONITOR);
		ps.setInt(1,chavePessoaMonitor);
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			return rs.getInt("qtd");
		
		return 0;
	}

}
