package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import pmon.dto.*;
import dao.DAOBase;





public class FrequenciaDAO extends DAOBase {
	private static final String SQL_INSEREENTRADA = "INSERT INTO pmFrequencia VALUES (?,?,?,?,?, ?)";
	private static final String SQL_INSERESAIDA = "UPDATE pmFrequencia" +
	" set horaSaida = ?," +
	" autenticaSaida = ? " +
	" WHERE chavePessoaMonitor = ?" +
	" AND dtEntrada = ?"+
	" AND horaEntrada = ?";
	private static final String SQL_BUSCARFREQUENCIA = "SELECT * from pmFrequencia WHERE chavePessoaMonitor = ?" ;

	private static final String SQL_LISTARFREQUENCIA = "SELECT p.nomePessoa, f.dtEntrada, " +
	" f.horaEntrada, f.horaSaida, f.autenticaEntrada, f.autenticaSaida, f.chavePessoaMonitor" +
	" from pmFrequencia f, maiorPessoa p" +
	" WHERE f.chavePessoaMonitor = p.chavePessoa" ;
	
	private static final String SQL_LISTARFREQUENCIADOSATIVOS = "SELECT p.nomePessoa, f.dtEntrada, " +
	" f.horaEntrada, f.horaSaida, f.autenticaEntrada, f.autenticaSaida, f.chavePessoaMonitor" +
	" from pmFrequencia f, maiorPessoa p, maiorMonitor mm" +
	" WHERE f.chavePessoaMonitor = p.chavePessoa" +
	" AND mm.dtSaida is NULL" ;

	private static final String SQL_BUSCARENTRADA = "SELECT * from pmFrequencia" +
	" WHERE chavePessoaMonitor = ?" +
	" AND dtEntrada = ?";
	private static final String SQL_EXCLUIRFREQUENCIA = "DELETE FROM pmFrequencia WHERE chavePessoaMonitor = ? AND dtEntrada = ? AND horaEntrada = ?";
	private static final String SQL_ALTERARFREQUENCIA = "UPDATE pmAtendimento" +
			" set duracao = ?, " +
			" dtAtendimento = ?," +
			" localAtender = ?" +
			" WHERE idAtendimento = ?";

	public Collection listarFrequenciaPorMonitor(int chavePessoaMonitor) throws SQLException {
		Collection result = new ArrayList();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARFREQUENCIA);
		ps.setInt(1,chavePessoaMonitor);

		ResultSet rs = ps.executeQuery();

		while ( rs.next() ) {
			FrequenciaDTO dto = new FrequenciaDTO();
			put(dto, rs);
			result.add(dto);
		}
		rs.close();
		ps.close();
		return result;
	}
	public Collection listarFrequencia() throws SQLException {
		Collection result = new ArrayList();

		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTARFREQUENCIA);

		ResultSet rs = ps.executeQuery();

		while ( rs.next() ) {
			FrequenciaDTO dto = new FrequenciaDTO();
			put(dto, rs);
			result.add(dto);
		}
		rs.close();
		ps.close();
		return result;
	}
	public Collection pesquisarFrequencia(FrequenciaPesquisaDTO freqDto) throws SQLException {
		StringBuffer sql = new StringBuffer("SELECT chavePessoaMonitor, nomePessoa, nomeDisciplina, dtEntrada, horaEntrada, autenticaEntrada, horaSaida, autenticaSaida " +
				" from pmFrequencia f, maiorPessoa p,maiorMonitor m , maiorDisciplina d" +
				" where m.chavePessoa = p.chavePessoa AND f.chavePessoaMonitor = p.chavePessoa AND m.idDisciplina = d.idDisciplina " +
				" and year(dtEntrada) = m.ano  and if(month(dtEntrada) < 7, 1,2) = m.semestre ");
		if(freqDto.getChaveMonitor() != null){
			sql.append(" AND chavePessoaMonitor = " + freqDto.getChaveMonitor() );
		}
		if(freqDto.getDataFinal() != null){
			sql.append(" AND dtEntrada <= '" + pmon.apoio.Data.getData2(freqDto.getDataFinal()) + "'" );
		}
		if(freqDto.getDataInicio() != null){
			sql.append(" AND dtEntrada >= '" + pmon.apoio.Data.getData2(freqDto.getDataInicio()) + "'" );
		}
		if(freqDto.getNomeMonitor()!= null){
			sql.append(" AND  p.nomePessoa like '%" +freqDto.getNomeMonitor() + "%'" );
		}
		if(freqDto.getHoraEntrada()!= null){
			sql.append(" AND  f.horaEntrada = '" +freqDto.getHoraEntrada() + "'" );
		}

		sql.append(" ORDER BY nomepessoa asc , dtEntrada DESC, horaEntrada asc");

		Collection result = new ArrayList();

		PreparedStatement ps = getConnection().prepareStatement(sql.toString());
		System.out.println(ps.toString());
		ResultSet rs = ps.executeQuery();

		while ( rs.next() ) {
			FrequenciaDTO dto = new FrequenciaDTO();
			putPesquisa(dto, rs);
			result.add(dto);
		}
		rs.close();
		ps.close();
		return result;
	}
	public Collection buscarEntrada(int chavePessoaMonitor, java.sql.Date data) throws SQLException {
		Collection result = new ArrayList();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARENTRADA);
		ps.setInt(1,chavePessoaMonitor);
		ps.setDate(2,data);

		ResultSet rs = ps.executeQuery();

		while ( rs.next() ) {
			FrequenciaDTO dto = new FrequenciaDTO();
			put(dto, rs);
			result.add(dto);
		}
		rs.close();
		ps.close();
		return result;
	}


	private void put(FrequenciaDTO dto, ResultSet rs) throws SQLException {
		dto.setData(rs.getDate("dtEntrada"));
		dto.setHoraEntrada(rs.getString("horaEntrada"));
		dto.setHoraSaida(rs.getString("horaSaida"));
		dto.setChavePessoaMonitor(rs.getInt("chavePessoaMonitor"));
		dto.setAutenticaEntrada(rs.getString("autenticaEntrada"));
		dto.setAutenticaSaida(rs.getString("autenticaSaida"));
	}
	private void putPesquisa(FrequenciaDTO dto, ResultSet rs) throws SQLException {
		dto.setData(rs.getDate("dtEntrada"));
		dto.setHoraEntrada(rs.getString("horaEntrada"));
		dto.setHoraSaida(rs.getString("horaSaida"));
		dto.setChavePessoaMonitor(rs.getInt("chavePessoaMonitor"));
		dto.setAutenticaEntrada(rs.getString("autenticaEntrada"));
		dto.setAutenticaSaida(rs.getString("autenticaSaida"));
		dto.setDisciplina(rs.getString("nomeDisciplina"));
		dto.setNomeMonitor(rs.getString("nomePessoa"));
	}

	public void registrarSaida(FrequenciaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERESAIDA);

		ps.setString(1,dto.getHoraSaida());
		ps.setString(2,dto.getAutenticaSaida());
		ps.setInt(3,dto.getChavePessoaMonitor());
		ps.setDate(4,dto.getData());
		ps.setString(5,dto.getHoraEntrada());

		ps.executeUpdate();
		ps.close();	
	}
	public void registrarEntrada(FrequenciaDTO dto)throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSEREENTRADA);

		ps.setInt(1,dto.getChavePessoaMonitor());
		ps.setDate(2,dto.getData());
		ps.setString(3,dto.getHoraEntrada());
		ps.setString(4,dto.getAutenticaEntrada());
		ps.setString(5,dto.getHoraSaida());
		ps.setString(6,dto.getAutenticaSaida());

		ps.executeUpdate();
		ps.close();	
	}
	public Collection listarFrequenciaDosAtivos()throws SQLException {
		Collection result = new ArrayList();

		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTARFREQUENCIADOSATIVOS);

		ResultSet rs = ps.executeQuery();

		while ( rs.next() ) {
			FrequenciaDTO dto = new FrequenciaDTO();
			put(dto, rs);
			result.add(dto);
		}
		rs.close();
		ps.close();
		return result;
	}
	public void excluirFrequencia(FrequenciaDTO dto) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRFREQUENCIA);
		ps.setInt(1,dto.getChavePessoaMonitor());
		ps.setDate(2,dto.getData());
		ps.setString(3, dto.getHoraEntrada() );
		System.out.println(ps);
		
		ps.executeUpdate();
		ps.close();

	}





}
