package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import pmon.dto.MonitorDTO;
import dao.DAOBase;

public class MonitorDAO extends DAOBase {
	private static final String SQL_LISTDistinct = "select DISTINCT p.chavePessoa, p.nomePessoa " +
			" from maiorMonitor m, maiorPessoa p, maiorDisciplina d  " +
			" where m.chavePessoa = p.chavePessoa " +
			" AND d.idDisciplina = m.idDisciplina " +
			" ORDER BY p.nomePessoa";
	private static final String SQL_LIST = "select  p.chavePessoa, p.nomePessoa, d.nomeDisciplina " +
	" from maiorMonitor m, maiorPessoa p, maiorDisciplina d  " +
	" where m.chavePessoa = p.chavePessoa " +
	" AND d.idDisciplina = m.idDisciplina " +
	" ORDER BY p.nomePessoa";

	private static final String SQL_LIST_ATIVOS = "select DISTINCT p.chavePessoa, p.nomePessoa, d.nomeDisciplina, m.dtSaida" +
			" from maiorMonitor m, maiorPessoa p, maiorDisciplina d  " +
			" where m.chavePessoa = p.chavePessoa " +
			" AND d.idDisciplina = m.idDisciplina AND m.dtSaida IS NULL" +
			" ORDER BY p.nomePessoa";
	
	public Collection listar() throws SQLException {
        Collection result = new ArrayList();
        Statement stm =  getConnection().createStatement();
        ResultSet rs = stm.executeQuery(SQL_LIST);
         while ( rs.next() ) {
        	MonitorDTO dto = new MonitorDTO();
            put(dto, rs);
            result.add(dto);
        }
        
        rs.close();
        stm.close();
        
        return result;
    }
	public Collection listarDistinct() throws SQLException {
        Collection result = new ArrayList();
        Statement stm =  getConnection().createStatement();
        ResultSet rs = stm.executeQuery(SQL_LISTDistinct);
       
        while ( rs.next() ) {
        	MonitorDTO dto = new MonitorDTO();
            putDistinct(dto, rs);
            result.add(dto);
        }
        
        rs.close();
        stm.close();
        
        return result;
    }
    private void put(MonitorDTO dto, ResultSet rs) throws SQLException {
    	 dto.setNomePessoa(rs.getString("nomePessoa"));
         dto.setChavePessoa(rs.getString("chavePessoa"));
         dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
    }
    private void putDistinct(MonitorDTO dto, ResultSet rs) throws SQLException {
   	 	dto.setNomePessoa(rs.getString("nomePessoa"));
        dto.setChavePessoa(rs.getString("chavePessoa"));
       
   }
    public Collection listarAtivos() throws SQLException {
        Collection result = new ArrayList();
        Statement stm =  getConnection().createStatement();
        ResultSet rs = stm.executeQuery(SQL_LIST_ATIVOS);
        
        while ( rs.next() ) {
        	MonitorDTO dto = new MonitorDTO();
            put(dto, rs);
            result.add(dto);
        }
        
        rs.close();
        stm.close();
        
        return result;
    }
    
	public String Autentica(int chavePessoaMonitor) throws SQLException {
		final String aut ="SELECT senha FROM maiorAcesso WHERE chavePessoa = " + chavePessoaMonitor;
		Statement stm =  getConnection().createStatement();
	    ResultSet rs = stm.executeQuery(aut);
	    if(rs.next())
	    	return rs.getString("senha");
		return null;
	}
}

