package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;
import pmon.dto.MonitoriaPesquisaDTO;
import pmon.dto.MonitoriaDTO;
import dao.DAOBase;

public class MonitoriaDAO extends DAOBase {
	private static final String SQL_LIST = "select m.chavePessoaAluno, m.idDisciplina, m.ano," +
			" m.semestre, m.diaSemana, m.sala, m.horario, d.nomeDisciplina, p.nomePessoa" +
			" from maiorDisciplina d, maiorPessoa p, pmMonitoria m" +
			" where m.chavePessoaAluno = p.chavePessoa and m.idDisciplina = d.idDisciplina";
	private static final String SQLBUSCAMONITORIA = "select m.chavePessoaAluno, m.idDisciplina, m.ano, m.semestre, m.diaSemana, m.sala, m.horario, d.nomeDisciplina, " +
	 " p.nomePessoa, p.email, m.campus from maiorDisciplina d, maiorPessoa p, pmMonitoria m" +
	 " where p.chavePessoa=m.chavePessoaAluno and d.idDisciplina=m.idDisciplina and p.chavePessoa= ? and d.idDisciplina = ? and ano = ? and semestre = ?";
	
	private static final String SQL_LIST_SEMESTRE_ATUAL = "select concat(SUBSTRING_INDEX(p.nomePessoa,' ',1), ' ', SUBSTRING_INDEX(p.nomePessoa,' ',-1),"+
	"' (', p.email,')') as monitorEmail, m.chavePessoaAluno, m.idDisciplina, m.ano, " +
	" m.semestre, m.diaSemana, m.sala, m.horario, d.nomeDisciplina, mm.dtSaida" +
	" from maiorDisciplina d, maiorPessoa p, pmMonitoria m, maiorMonitor mm" +
	" where m.chavePessoaAluno = p.chavePessoa and m.chavePessoaAluno= mm.chavePessoa and m.idDisciplina = d.idDisciplina and m.semestre=? and m.ano=? order by idDisciplina";

	private static final String SQL_LIST_SEMESTRE_ANTERIORES = "select concat(SUBSTRING_INDEX(p.nomePessoa,' ',1), ' ', SUBSTRING_INDEX(p.nomePessoa,' ',-1),"+
	"' (', p.email,')') as monitorEmail, m.chavePessoaAluno, m.idDisciplina, m.ano,"+
	"m.semestre, m.diaSemana, m.sala, m.horario, d.nomeDisciplina"+
	"from maiorDisciplina d, maiorPessoa p, pmMonitoria m" +
	"where m.chavePessoaAluno = p.chavePessoa and m.idDisciplina = d.idDisciplina and m.semestre=? and ano=? order by idDisciplina";
    private static final String SQL_SEMESTRE = "select distinct semestre from pmMonitoria";
    private static final String SQL_ANO = "select distinct ano from pmMonitoria order BY ano DESC";
    private static final String SQLALTERARMONITORIA= "UPDATE pmMonitoria" +
	" set chavePessoaAluno = ?," +
	" idDisciplina = ?, ano = ?,  semestre = ?," +
	" diaSemana = ?, sala = ? , horario = ?, campus = ?" +
	" where chavePessoaAluno = ? and idDisciplina = ? and semestre = ? and ano = ?";

    private static final String SQL_EXCLUIRMONITORIA = "DELETE FROM pmMonitoria WHERE chavePessoaAluno = ? and idDisciplina = ? and semestre = ? and ano = ?";
    
	
   public Collection listar() throws SQLException {
       Collection result = new ArrayList();
       Statement stm =  getConnection().createStatement();
       ResultSet rs = stm.executeQuery(SQL_LIST);
       
       while ( rs.next() ) {
           MonitoriaDTO dto = new MonitoriaDTO();
           put(dto, rs);
           result.add(dto);
       }
       
       rs.close();
       stm.close();
       
       
       return result;
   }
private void put(MonitoriaDTO dto, ResultSet rs) throws SQLException {
	dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
    dto.setNomeAluno(rs.getString("monitorEmail"));
    dto.setDiaSemana(rs.getString("diaSemana"));
    dto.setHorario(rs.getString("horario"));
    dto.setSala(rs.getString("sala"));
    dto.setChavePessoaAluno(rs.getInt("chavePessoaAluno"));
    dto.setSemestre(rs.getString("semestre"));
    dto.setAno(rs.getInt("ano"));
    dto.setIdDisciplina(rs.getInt("idDisciplina"));
    dto.setCampus(rs.getString("campus"));
  
}

public int gravaMonitoria(MonitoriaDTO dto) throws SQLException
{      int ret = 0;
	   Statement stm = getConnection().createStatement();
	
	   String cmd = "INSERT INTO pmMonitoria VALUES("+dto.getChavePessoaAluno()+","+dto.getIdDisciplina()+","+dto.getAno()+
		", '"+dto.getSemestre()+"','"+dto.getSala()+"','"+dto.getDiaSemana()+"','"+dto.getHorario()+"','"+dto.getCampus()+"')";
	   
	   ret = stm.executeUpdate(cmd);
		
		
		stm.close();
		//con.commit();
		
		return ret;
	   
}
public void alterarMonitoria(MonitoriaDTO dto, int chavePessoa, int Disciplina, int ano, String semestre) throws SQLException {
	PreparedStatement ps = getConnection().prepareStatement(SQLALTERARMONITORIA);

	ps.setInt(1,dto.getChavePessoaAluno());
	ps.setInt(2,dto.getIdDisciplina());
	ps.setInt(3,dto.getAno());
	ps.setString(4,dto.getSemestre());
	ps.setString(5,dto.getDiaSemana());
	ps.setString(6,dto.getSala());
	ps.setString(7,dto.getHorario());
	ps.setString(8, dto.getCampus());
	ps.setInt(9, chavePessoa);
	ps.setInt(10, Disciplina);
	ps.setString(11, semestre);
	ps.setInt(12, ano);
	
	ps.executeUpdate();
	ps.close();	
	
}
public Collection pesquisar(MonitoriaPesquisaDTO dto) throws SQLException {
	final StringBuffer SQL_PESQ = new StringBuffer("select concat(SUBSTRING_INDEX(p.nomePessoa,' ',1), ' ',"+
    				" SUBSTRING_INDEX(p.nomePessoa,' ',-1),' (', p.email,')') as monitorEmail, m.chavePessoaAluno, m.idDisciplina, m.ano,");
	SQL_PESQ.append(" m.semestre, m.diaSemana, m.sala, m.horario, d.nomeDisciplina, m.campus, mm.dtSaida" );
	SQL_PESQ.append(" from maiorDisciplina d, maiorPessoa p, pmMonitoria m, maiorMonitor mm" );
	SQL_PESQ.append(" where m.chavePessoaAluno = p.chavePessoa and m.idDisciplina = d.idDisciplina and m.chavePessoaAluno= mm.chavePessoa");
	SQL_PESQ.append(" and m.semestre=mm.semestre ");
	if(!dto.getDisciplina().equals("Todas"))
		SQL_PESQ.append(" and d.idDisciplina = '"+dto.getDisciplina()+"'");
	if(!dto.getCampus().equals("Todos"))
		SQL_PESQ.append(" and m.campus = '"+dto.getCampus()+"'");
	if(!dto.getDiaSemana().equals("Todos"))
		SQL_PESQ.append(" and m.diaSemana like '%"+ dto.getDiaSemana()+"%'");
	SQL_PESQ.append(" and m.semestre = '"+dto.getSemestre()+"' and m.ano = "+dto.getAno());
	SQL_PESQ.append(" ORDER BY idDisciplina");


	Collection result = new ArrayList();
	Statement stm =  getConnection().createStatement();
	ResultSet rs = stm.executeQuery(SQL_PESQ.toString());

	
	if((dto.getSemestre().equals(dto.getSemestreAtual())&&(dto.getAno()==dto.getAnoAtual()))){
		while ( rs.next() ) {
	        if(rs.getDate("dtSaida")==null){
	        	MonitoriaDTO dto3 = new MonitoriaDTO();
	        	put(dto3, rs);
	            result.add(dto3);
	        }
	    }
	}
	else{
		while ( rs.next() ) {
			MonitoriaDTO dto2 = new MonitoriaDTO();
			put(dto2, rs);
			result.add(dto2);
		}
	}
	rs.close();
	stm.close();

	return result;
}
public MonitoriaDTO buscaMonitoria(int chavePessoaAluno, int idDisciplina, int ano, String semestre) throws SQLException {
	
	MonitoriaDTO dto = new MonitoriaDTO();
	PreparedStatement ps;
		ps = getConnection().prepareStatement(SQLBUSCAMONITORIA);
		ps.setInt(1,chavePessoaAluno);
		ps.setInt(2, idDisciplina);
		ps.setInt(3, ano);
		ps.setString(4, semestre);
		
		ResultSet rs = ps.executeQuery();
		
		if(rs.next())
			putbusca(dto,rs);

		
		ps.close();
		return dto;
	
}

private void putbusca(MonitoriaDTO dto, ResultSet rs) throws SQLException {
	dto.setChavePessoaAluno(rs.getInt("chavePessoaAluno"));
	dto.setNomeAluno(rs.getString("nomePessoa"));
	dto.setIdDisciplina(rs.getInt("idDisciplina"));
	dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
	dto.setSala(rs.getString("sala"));
	dto.setSemestre(rs.getString("semestre"));
	dto.setAno(rs.getInt("ano"));
	dto.setDiaSemana(rs.getString("diaSemana"));
	dto.setHorario(rs.getString("horario"));
	dto.setCampus(rs.getString("campus"));
	dto.setEmail(rs.getString("email"));
	
}
public Collection listarMonitoriaSemestreAtual(String semestreAtual, int anoAtual) throws SQLException {
    Collection result = new ArrayList();
    PreparedStatement ps;
	ps = getConnection().prepareStatement(SQL_LIST_SEMESTRE_ATUAL);
	ps.setString(1,semestreAtual);
	ps.setInt(2, anoAtual);
	ResultSet rs = ps.executeQuery();
//	System.out.println(rs.getDate("dtSaida"));
	
    while ( rs.next() ) {
        if(rs.getDate("dtSaida")==null){
        	MonitoriaDTO dto = new MonitoriaDTO();
        	put(dto, rs);
            result.add(dto);
        }
    }
    
    rs.close();
    ps.close();
    
    return result;
 }
public Collection listarMonitoriaSemestreAnterior(String semestreAtual, int anoAtual) throws SQLException {
    Collection result = new ArrayList();
    PreparedStatement ps;
	ps = getConnection().prepareStatement(SQL_LIST_SEMESTRE_ANTERIORES);
	ps.setString(1,semestreAtual);
	ps.setInt(2, anoAtual);
	ResultSet rs = ps.executeQuery();

    while ( rs.next() ) {
        MonitoriaDTO dto = new MonitoriaDTO();
        put(dto, rs);
        result.add(dto);
    }
    
    rs.close();
    ps.close();
    
    return result;
 }

public Collection listarSemestre() throws SQLException {
	Collection result = new ArrayList();
    Statement stm =  getConnection().createStatement();
    ResultSet rs = stm.executeQuery(SQL_SEMESTRE);
    
    while ( rs.next() ) {
        MonitoriaDTO dto = new MonitoriaDTO();
    	putSemestre(dto, rs);
        result.add(dto);
    }
    
    rs.close();
    stm.close();
    return result;
}

private void putSemestre(MonitoriaDTO dto, ResultSet rs) throws SQLException {
	dto.setSemestreEscolhido(rs.getString("semestre"));
 }
public Collection listarAno() throws SQLException {
	Collection result = new ArrayList();
    Statement stm =  getConnection().createStatement();
    ResultSet rs = stm.executeQuery(SQL_ANO);
    
    while ( rs.next() ) {
        MonitoriaDTO dto = new MonitoriaDTO();
    	putAno(dto, rs);
        result.add(dto);
    }
    
    rs.close();
    stm.close();
    return result;
}

private void putAno(MonitoriaDTO dto, ResultSet rs) throws SQLException {
	dto.setAnoEscolhido(rs.getInt("ano"));
}

public void excluiMonitoria(int chaveMonitor, int idDisciplina, int ano, String semestre)throws SQLException {
	PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRMONITORIA);
	ps.setInt(1,chaveMonitor);
	ps.setInt(2,idDisciplina);
	ps.setString(3,semestre);
	ps.setInt(4,ano);
	
	
	
	ps.executeUpdate();
	ps.close();

}
}






