package pmon.dao;

import java.sql.*;

import pmon.dto.ParecerDTO;
import dao.DAOBase;

public class ParecerDAO extends DAOBase {
	private static final String SQL_BUSCAPARECERPORID =
		"select pa.parecerMonitor, pa.notificar, pa.parecerProfessor"+
	" FROM pmAtendimento a"+
	", pmParecer pa"+
	" WHERE a.idAtendimento = pa.idAtendimento" +
	" and a.idAtendimento = ?";

	private static final String SQL_EXCLUIRPARECER = "DELETE FROM pmParecer WHERE idAtendimento = ?";
	private static final String SQL_INSERT = "INSERT INTO pmParecer" +
	" VALUES(?,?,?,?)";

	private static final String SQL_ALTERARPARECER = "UPDATE pmParecer" +
			" set parecerMonitor = ?," +
			" parecerProfessor =?," +
			" notificar = ?" +
			" WHERE idAtendimento = ?";
	
	
	public void alterarParecer(ParecerDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARPARECER);
		
		ps.setString(1,dto.getParecerMonitor());
		ps.setString(2,dto.getParecerProfessor());
		ps.setString(3,""+dto.getNotificar());
		ps.setInt(4,dto.getIdAtendimento());
		
		System.out.println(ps.toString());
		ps.executeUpdate();
		ps.close();	
	}

	public void cadastrarParecer(ParecerDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT);
		ps.setInt(1,dto.getIdAtendimento());
		ps.setString(2,dto.getParecerMonitor());
		ps.setString(3,""+dto.getNotificar());
		ps.setString(4,dto.getParecerProfessor());
		
		System.out.println(ps.toString());
		ps.executeUpdate();
		ps.close();	
	}

	public void excluirParecer(int idAtendimento)throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUIRPARECER);
		ps.setInt(1,idAtendimento);
		
		
		ps.executeUpdate();
		ps.close();


	}
	public ParecerDTO buscaParecerPorId(int idAtendimento) throws SQLException{
		ParecerDTO dto = new ParecerDTO();
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAPARECERPORID);
		ps.setInt(1,idAtendimento);
		ResultSet rs = ps.executeQuery();
		
		
		if(rs.next())
			putParecer(dto,rs);
		ps.close();
		return dto;
	}
	public static void putParecer(ParecerDTO dto, ResultSet rs) throws SQLException {
		dto.setParecerMonitor(rs.getString("parecerMonitor"));
		dto.setParecerProfessor(rs.getString("parecerProfessor"));
		dto.setNotificar(rs.getString("notificar").charAt(0));
		dto.setIdAtendimento(rs.getInt("idAtendimento"));

	}
	public boolean temParecer(int idAtendimento) throws SQLException {

		
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAPARECERPORID);
		ps.setInt(1,idAtendimento);
		ResultSet rs = ps.executeQuery();
		
		
		if(rs.next())
			return true;
		return false;
	}
	

}