package pmon.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

import pmon.apoio.Data;
import pmon.dto.AtendimentoDTO;
import pmon.dto.ProfessorDTO;
import dao.DAOBase;

public class ProfessorDAO extends DAOBase {
	private static final String SQL_LIST = "select pr.chavePessoa, ps.nomePessoa from maiorProfessor pr," +
			" maiorPessoa ps where pr.chavePessoa = ps.chavePessoa ORDER BY ps.nomePessoa";
	
	public Collection listar() throws SQLException {
        Collection result = new ArrayList();
        Statement stm =  getConnection().createStatement();
        ResultSet rs = stm.executeQuery(SQL_LIST);
        
        while ( rs.next() ) {
        	ProfessorDTO dto = new ProfessorDTO();
            put(dto, rs);
            result.add(dto);
        }
        
        rs.close();
        stm.close();
        
        return result;
    }
    private void put(ProfessorDTO dto, ResultSet rs) throws SQLException {
        dto.setNomePessoa(rs.getString("nomePessoa"));
        dto.setChavePessoa(rs.getString("chavePessoa"));
        
    }
	public boolean getTurmaAluno(AtendimentoDTO dto) throws SQLException, ParseException{
		final String SQL_BUSCAPROFESSORDISICPLINA ="select p.nomePessoa,"+
		" d.nomeDisciplina, ta.chavePessoaAluno "+
		" from maiorPessoa p, "+
		" maiorTurma t, maiorTurma_Aluno ta, maiorDisciplina d"+
		" where ta.chavePessoaAluno = p.chavePessoa"+
		" and ta.ano = t.ano and ta.semestre = t.semestre"+
		" and ta.ano = ? and ta.semestre = ?"+
		" and ta.codigoTurma = t.codigoTurma"+
		" and d.idDisciplina = t.idDisciplina"+
		" and ta.idDisciplina = t.idDisciplina"+
		" and ta.chavePessoaAluno = ?"+
		" and d.idDisciplina = ?" ;
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAPROFESSORDISICPLINA);
		ps.setInt(1,Data.getAno(dto.getDataAtendimento()));
		ps.setInt(2,Data.getSemestre(dto.getDataAtendimento()));
		ps.setInt(3,dto.getCPAluno());
		ps.setInt(4,dto.getIdDisciplina());
		
		ResultSet rs = ps.executeQuery();
		if (rs.next()){
			ps.close();
			return true;
		}
		else{
			ps.close();
			return false;
		}
		
		
	}
}
