package pmon.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import pmon.apoio.Data;
import pmon.dto.RelatorioDTO;
import pmon.dto.RelatorioPesquisaDTO;
import dao.DAOBase;





public class RelatorioDao extends DAOBase {

	private static final String RELATORIO_MONITOR_X_QTD_ATENDIMENTOS = "SELECT p.chavePessoaMonitor , m.nomePessoa as identificador, count(*) as valor FROM pmAtendimento p, maiorPessoa m " +
			" WHERE m.chavePessoa = p.chavePessoaMonitor " ;

	private static final String RELATORIO_DISCIPLINA_X_QTD_ATENDIMENTOS = " SELECT p.idDisciplina, m.nomeDisciplina  as identificador, count(*) as valor FROM pmAtendimento p, maiorDisciplina m " +
			" WHERE m.idDisciplina = p.idDisciplina " ;

	private static final String RELATORIO_ALUNO_X_QTD_ATENDIMENTOS = "SELECT p.chavePessoaAluno, m.nomePessoa  as identificador, count(*) as valor FROM pmAtendimento p, maiorPessoa m " +
			" WHERE m.chavePessoa = p.chavePessoaAluno " ;

	private static final String RELATORIO_PROFESSOR_X_QTD_ATENDIMENTOS = "";
	private static final String RELATORIO_DIA_SEMANA_X_QTD_ATENDIMENTOS = " SELECT count(*) as valor, Dayname(p.dtAtendimento)  as identificador FROM pmAtendimento p " ;

	private static final String RELATORIO_SEMANA_X_QTD_ATENDIMENTOS = " SELECT count(*) as valor, weekofyear(p.dtAtendimento)  as identificador FROM pmAtendimento p ";

	private static final String RELATORIO_MES_X_QTD_ATENDIMENTOS = "SELECT monthname(p.dtAtendimento)  as identificador, count(*) as valor FROM pmAtendimento p " ;
	private static final String RELATORIO_DISCIPLINA_X_QTD_MONITORES = "SELECT md.nomeDisciplina  as identificador, count(*) as valor " +
			" FROM maiorMonitor m, maiorDisciplina md" +
			" WHERE md.idDisciplina = m.idDisciplina " +
			" GROUP BY identificador " +
			" ORDER BY identificador";
	public Collection getRelatorio(String sql) throws SQLException {
		Collection result = new ArrayList();
		Statement stm =  getConnection().createStatement();
		System.out.println(sql);
		ResultSet rs = stm.executeQuery(sql);
		
		while ( rs.next() ) {
			RelatorioDTO dto = new RelatorioDTO();
			put(dto, rs);
			result.add(dto);
		}

		rs.close();
		stm.close();

		return result;
	}
	private void put(RelatorioDTO dto, ResultSet rs) throws SQLException {
		dto.setIdentificador(rs.getString("identificador"));
		dto.setValor(rs.getInt("valor"));
	}
	/**
	 * @param pesquisa 
	 * @return
	 * @throws SQLException 
	 */
	public Collection getRelatorioMonitorAtendimento(RelatorioPesquisaDTO dto) throws SQLException {
		// TODO Auto-generated method stub
		//return getRelatorio(RELATORIO_MONITOR_X_QTD_ATENDIMENTOS);
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_MONITOR_X_QTD_ATENDIMENTOS);
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioDisciplinaAtendimento(RelatorioPesquisaDTO dto) throws SQLException {
		// TODO Auto-generated method stub
		
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_DISCIPLINA_X_QTD_ATENDIMENTOS);
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioAlunoAtendimento(RelatorioPesquisaDTO dto) throws SQLException {
		// TODO Auto-generated method stub
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_ALUNO_X_QTD_ATENDIMENTOS);
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioProfessorAtendimento(RelatorioPesquisaDTO dto)throws SQLException {
		// TODO Auto-generated method stub
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_PROFESSOR_X_QTD_ATENDIMENTOS);
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioDiaSemanaAtendimento(RelatorioPesquisaDTO dto) throws SQLException {
		// TODO Auto-generated method stub
    	StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_DIA_SEMANA_X_QTD_ATENDIMENTOS);
    	SQL_PESQ.append(" WHERE 'a' = 'a' " );
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioMesAtendimento(RelatorioPesquisaDTO dto)throws SQLException {
		// TODO Auto-generated method stub
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_MES_X_QTD_ATENDIMENTOS);
		SQL_PESQ.append(" WHERE 'a' = 'a' " );
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioDisciplinaMonitor(RelatorioPesquisaDTO dto)throws SQLException {
		// TODO Auto-generated method stub
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_DISCIPLINA_X_QTD_MONITORES);
			
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}
	/**
	 * @return
	 */
	public Collection getRelatorioSemanaAtendimento(RelatorioPesquisaDTO dto)throws SQLException {
		// TODO Auto-generated method stub
		StringBuffer SQL_PESQ = new StringBuffer(RELATORIO_SEMANA_X_QTD_ATENDIMENTOS);
		SQL_PESQ.append(" WHERE 'a' = 'a' " );
		if(dto.getDataF()!= null){ // se existir data final
			SQL_PESQ.append(" AND p.dtAtendimento <= '" +Data.getData2(dto.getDataF())+"'" );
		}
		if(dto.getDataI()!= null) // se existir data de inicio
			SQL_PESQ.append(" AND p.dtAtendimento >= '" +Data.getData2(dto.getDataI())+"'" );
		
		SQL_PESQ.append( " GROUP BY identificador ORDER BY identificador");
		return getRelatorio(SQL_PESQ.toString());
	}

}
