package pmon.model;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;

import pmon.dao.AlunoDAO;
import dao.DAOFactory;
import dto.LoginDTO;

public class AlunoModel extends ModelBase{
    private AlunoDAO dao; 
    
    public AlunoModel(LoginDTO login) {
		super(login);
	}
    
	public Collection listarAlunos() {
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.listarAlunos();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}
	private AlunoDAO getDao(){
		if(dao ==null)
			try {
				dao = (AlunoDAO)DAOFactory.getInstance().getDAO("pmon.dao.AlunoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}

}
