package pmon.model;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;

import pmon.dao.AtendimentoDao;
import pmon.dto.AtendimentoDTO;
import pmon.dto.AtendimentoPesquisaDTO;
import dao.DAOFactory;
import dto.LoginDTO;



public class AtendimentoModel extends ModelBase{
	private AtendimentoDao dao;
	
	public AtendimentoModel(LoginDTO login) {
		super(login);
	}
	
	public Collection listarAtendimentos(){
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.listar();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}
	public Collection listarAtendimentos(String chavePessoaMonitor){
		Collection result;
		try {
			abreConexao(getDao(),dao);
			result = dao.listar(chavePessoaMonitor);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
	}
	public Collection pesquisar(AtendimentoPesquisaDTO dto)  {
		Collection result;
		try {
			abreConexao(getDao(),dao);
			result = dao.pesquisar(dto);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
	}
	public AtendimentoDTO buscaAtendimentoPorId(int idAtendimento) {
		AtendimentoDTO dto;
	try {
		abreConexao(getDao(),dao);
		dto = dao.buscaAtendimentoPorId(idAtendimento);
		fechaConexao(dao);
		return dto;
	} catch (SQLException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
		
	return null;
	}
	
	public boolean cadastrar(AtendimentoDTO dto) {
		try {
			abreConexao(getDao(),dao);
			dao.cadastrarAtendimento(dto);
			fechaConexao(dao);
		    return true;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		
		
	}
	public int alterarAtendimento(AtendimentoDTO dto) {
		try {
			abreConexao(getDao(),dao);
			dao.alterarAtendimento(dto);
			fechaConexao(dao);
		    return 1;
			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return 0;
		}
		
	}
	public int excluirAtendimento(int idAtendimento) {
		try {
			abreConexao(getDao(),dao);
			dao.excluirAtendimento(idAtendimento);
			fechaConexao(dao);
			return 1;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return 0;
		}
	}
	public int getUltimoInserido() {
		int ultimoInserido = 0;
		try {
			abreConexao(getDao(),dao);
			ultimoInserido = getDao().buscaUltimoInserido();
			fechaConexao(dao);
			return ultimoInserido;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return 0;
	}
	private AtendimentoDao getDao(){
//		if(dao ==null)
			try {
				dao = (AtendimentoDao)DAOFactory.getInstance().getDAO("pmon.dao.AtendimentoDao",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}

	/**
	 * @param c
	 * @param idAtendimento 
	 */
	public void alteraStatusParecer(char c, int idAtendimento) {
		try {
			abreConexao(getDao(),dao);
			dao.alteraStatusParecer(c,idAtendimento);
			fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	public int temParecerComNotificacaoNaoLido(int chavePessoaProfessor){
		try {
			int temParecerNovo = getDao().temParecerComNotificacaoNaoLido(chavePessoaProfessor);
			fechaConexao(dao);
			return temParecerNovo;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		return 0;
	}

	/**
	 * @param chavePessoa
	 * @return
	 */
	public Object temParecerComNotificacaoNaoLidoMonitor(int chavePessoaMonitor) {
		try {
			int temParecerNovo = getDao().temParecerComNotificacaoNaoLidoMonitor(chavePessoaMonitor);
			fechaConexao(dao);
			return temParecerNovo;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		return 0;
	}
}
