package pmon.model;



import java.sql.Date;
import java.sql.SQLException;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import model.ModelBase;

import pmon.dao.FrequenciaDAO;
import pmon.dto.*;
import dao.DAOFactory;
import dto.LoginDTO;



public class FrequenciaModel extends ModelBase{
	private FrequenciaDAO dao;
	
	public FrequenciaModel(LoginDTO login) {
		super(login);
	}
	
	public Collection listarFrequenciaPorMonitor(int chavePessoaMonitor) throws SQLException {
			
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.listarFrequenciaPorMonitor(chavePessoaMonitor);
			fechaConexao(dao);
			return result;  
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}
	public Collection listarFrequencia() throws SQLException {
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.listarFrequencia();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
		
	}
	public Collection listarFrequenciaDosAtivos() throws SQLException {
		
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.listarFrequenciaDosAtivos();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}
	public FrequenciaDTO buscarEntrada(int chavePessoaMonitor, java.sql.Date data) throws SQLException {

		FrequenciaDTO dto = new FrequenciaDTO();
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.buscarEntrada(chavePessoaMonitor, data);
			fechaConexao(dao);
			if(result == null)
		    	return dto;
		    for (Iterator iter = result.iterator(); iter.hasNext();) {
				FrequenciaDTO element = (FrequenciaDTO) iter.next();
				if(element.getHoraSaida()==null){
					return element;
				}
			}
    	} catch (SQLException e) {
			e.printStackTrace();
		}
		return dto;
	}
	public void registrarSaida(FrequenciaDTO dto) throws SQLException {
		try {
			abreConexao(getDao(),dao);
			dao.registrarSaida(dto);
			fechaConexao(dao);
    	} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	public void registrarEntrada(FrequenciaDTO dto) {
		try {
			abreConexao(getDao(),dao);
			dao.registrarEntrada(dto);
			fechaConexao(dao);
    	} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	public Collection pesquisarFrequencia(FrequenciaPesquisaDTO dto){
		try {
			Collection result;
			abreConexao(getDao(),dao);
			result = dao.pesquisarFrequencia(dto);
			fechaConexao(dao);
			return result;
			
    	} catch (SQLException e) {
			e.printStackTrace();
		}
    	return null;
	}
	public int excluirFrequencia(FrequenciaDTO dto){
		int ret;
		try {
			abreConexao(getDao(),dao);
			dao.excluirFrequencia(dto);
			fechaConexao(dao);
		    ret = 0;
    	} catch (SQLException e) {
    		ret = 1;
			e.printStackTrace();
		}
    	return ret;
	}
	
	private FrequenciaDAO getDao(){
//		if(dao ==null)
			try {
				dao = (FrequenciaDAO)DAOFactory.getInstance().getDAO("pmon.dao.FrequenciaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}
	
}
