package pmon.model;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import pmon.dto.MonitoriaPesquisaDTO;
import pmon.dao.MonitoriaDAO;
import pmon.dto.MonitoriaDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class MonitoriaModel extends ModelBase {
	private MonitoriaDAO dao;

	public MonitoriaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarMonitoria() {
		try {
			return getDao().listar();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public int gravaMonitoria(MonitoriaDTO dto) {
		try {
			return getDao().gravaMonitoria(dto);

		} catch (SQLException e) {

			e.printStackTrace();
			return 0;
		}

	}
	
	public Collection pesquisar(MonitoriaPesquisaDTO dto)  {
		Collection mon;
		try {
			mon = getDao().pesquisar(dto);
			return mon;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
	}

	private MonitoriaDAO getDao() {
		if (dao == null)
			try {
				dao = (MonitoriaDAO) DAOFactory.getInstance().getDAO("pmon.dao.MonitoriaDAO",
						getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}

	public MonitoriaDTO buscaMonitoria(int chavePessoa, int Disciplina, int ano, String semestre) {
		MonitoriaDTO dto = new MonitoriaDTO();
		try {
			dto = getDao().buscaMonitoria(chavePessoa, Disciplina, ano, semestre);
			return dto;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;

	}

	public Collection listarMonitoriaSemestreAtual(String semestreAtual, int anoAtual) {
		try {
			return getDao().listarMonitoriaSemestreAtual(semestreAtual, anoAtual);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarMonitoriaSemestreAnterior(String semestreAtual, int anoAtual) {
		try {
			return getDao().listarMonitoriaSemestreAnterior(semestreAtual, anoAtual);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarSemestre() {
		try {
			return getDao().listarSemestre();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarAno() {
		try {
			return getDao().listarAno();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public int alteraMonitoria(MonitoriaDTO dto, int chavePessoaAluno, int idDisciplina, int ano,
			String semestre) {

		try {
			getDao().alterarMonitoria(dto, chavePessoaAluno, idDisciplina, ano, semestre);
			return 1;

		} catch (SQLException e) {
			e.printStackTrace();
			return 0;
		}

	}

	public int excluirMonitoria(int chaveMonitor, int idDisciplina, int ano, String semestre) {
		try {
			getDao().excluiMonitoria(chaveMonitor, idDisciplina, ano, semestre);
			return 1;

		} catch (SQLException e) {
			e.printStackTrace();
			return 0;
		}

	}

}

