package pmon.model;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import pmon.dto.MonitoriaPesquisaDTO;
import pmon.dao.MonitoriaDAO;
import pmon.dto.MonitoriaDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class MonitoriaModel extends ModelBase {
	private MonitoriaDAO dao;

	public MonitoriaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarMonitoria() {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.listar();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public int gravaMonitoria(MonitoriaDTO dto) {
		try {
			int result;
			abreConexao(getDao(), dao);
			result = dao.gravaMonitoria(dto);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {

			e.printStackTrace();
			return 0;
		}

	}
	
	public Collection pesquisar(MonitoriaPesquisaDTO dto)  {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.pesquisar(dto);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
	}

	public MonitoriaDTO buscaMonitoria(int chavePessoa, int Disciplina, int ano, String semestre) {
		MonitoriaDTO dto = new MonitoriaDTO();
		try {
			abreConexao(getDao(), dao);
			dto = dao.buscaMonitoria(chavePessoa, Disciplina, ano, semestre);
			fechaConexao(dao);
			return dto;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;

	}

	public Collection listarMonitoriaSemestreAtual(String semestreAtual, int anoAtual) {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.listarMonitoriaSemestreAtual(semestreAtual, anoAtual);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarMonitoriaSemestreAnterior(String semestreAtual, int anoAtual) {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.listarMonitoriaSemestreAnterior(semestreAtual, anoAtual);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarSemestre() {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.listarSemestre();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Collection listarAno() {
		try {
			Collection result;
			abreConexao(getDao(), dao);
			result = dao.listarAno();
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public int alteraMonitoria(MonitoriaDTO dto, int chavePessoaAluno, int idDisciplina, int ano,
			String semestre) {

		try {
			abreConexao(getDao(), dao);
			dao.alterarMonitoria(dto, chavePessoaAluno, idDisciplina, ano, semestre);
			fechaConexao(dao);
			return 1;

		} catch (SQLException e) {
			e.printStackTrace();
			return 0;
		}

	}

	public int excluirMonitoria(int chaveMonitor, int idDisciplina, int ano, String semestre) {
		try {
			abreConexao(getDao(), dao);
			dao.excluiMonitoria(chaveMonitor, idDisciplina, ano, semestre);
			fechaConexao(dao);
			return 1;

		} catch (SQLException e) {
			e.printStackTrace();
			return 0;
		}

	}

	private MonitoriaDAO getDao() {
//		System.out.println(dao);
//		if (dao == null)
//			System.out.println("dao  nulo");
			try {
				dao = (MonitoriaDAO) DAOFactory.getInstance().getDAO("pmon.dao.MonitoriaDAO",
						getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}


}

