package pmon.model;

import java.sql.SQLException;

import model.ModelBase;

import pmon.dao.ParecerDAO;
import pmon.dto.ParecerDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class ParecerModel extends ModelBase{
	private ParecerDAO dao;
	
	public ParecerModel(LoginDTO login) {
		super(login);
	}
	
	public ParecerDTO buscaParecerPorId(int idAtendimento) {
		ParecerDTO dto;
		abreConexao(getDao(),dao);
	try {
		dto = dao.buscaParecerPorId(idAtendimento);
		fechaConexao(dao);
		return dto;
	} catch (SQLException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
		
	return null;
	}
	
	public void cadastrar(ParecerDTO dto) {
		try {
			abreConexao(getDao(),dao);
		    dao.cadastrarParecer(dto);
		    fechaConexao(dao);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
	}
	public int alterarParecer(ParecerDTO dto) {
		try {
			abreConexao(getDao(),dao);
		    dao.alterarParecer(dto);
		    fechaConexao(dao);
		    return 1;
			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return 0;
		}
		
	}
	public int excluirParecer(int idAtendimento) {
		try {
		    abreConexao(getDao(),dao);
		    dao.excluirParecer(idAtendimento);
		    fechaConexao(dao);
		    return 1;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return 0;
		}
	}
	public boolean temParecer(int idAtendimento) {
		boolean bool;
		try {
			abreConexao(getDao(),dao);
		    bool = dao.temParecer(idAtendimento);
		    fechaConexao(dao);
		    return bool;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
	}
	private ParecerDAO getDao(){
//		if(dao ==null)
			try {
				dao = (ParecerDAO)DAOFactory.getInstance().getDAO("pmon.dao.ParecerDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}

	

}
