package pmon.model;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import pmon.dao.RelatorioDao;
import pmon.dto.AtendimentoPesquisaDTO;
import pmon.dto.RelatorioPesquisaDTO;
import dao.DAOFactory;
import dto.LoginDTO;


public class RelatorioModel extends ModelBase{
	static final int RELATORIO_MONITOR_X_QTD_ATENDIMENTOS = 1;
	static final int RELATORIO_DISCIPLINA_X_QTD_ATENDIMENTOS = 2;
	static final int RELATORIO_ALUNO_X_QTD_ATENDIMENTOS = 3;
	static final int RELATORIO_PROFESSOR_X_QTD_ATENDIMENTOS = 4;
	static final int RELATORIO_DIA_SEMANA_X_QTD_ATENDIMENTOS = 5;
	static final int RELATORIO_MES_X_QTD_ATENDIMENTOS = 6;
	static final int RELATORIO_DISCIPLINA_X_QTD_MONITORES = 7;
	static final int RELATORIO_SEMANA_X_QTD_ATENDIMENTOS = 8;

	private RelatorioDao dao;

	public RelatorioModel(LoginDTO login) {
		super(login);
	}

	public Collection getRelatorioPorTipo(RelatorioPesquisaDTO pesquisa){
		Collection result = null;
		try {		
			abreConexao(getDao(),dao);

			switch (pesquisa.getTipoRelatorio()){
			case RELATORIO_MONITOR_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioMonitorAtendimento(pesquisa);
				break;
			}
			case RELATORIO_DISCIPLINA_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioDisciplinaAtendimento(pesquisa);
				break;
			}
			case RELATORIO_ALUNO_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioAlunoAtendimento(pesquisa);
				break;
			}
			case RELATORIO_PROFESSOR_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioProfessorAtendimento(pesquisa);
				break;
			}
			case RELATORIO_DIA_SEMANA_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioDiaSemanaAtendimento(pesquisa);
				break;
			}
			case RELATORIO_MES_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioMesAtendimento(pesquisa);
				break;
			}
			case RELATORIO_DISCIPLINA_X_QTD_MONITORES:{
				result = dao.getRelatorioDisciplinaMonitor(pesquisa);
				break;
			}
			case RELATORIO_SEMANA_X_QTD_ATENDIMENTOS:{
				result = dao.getRelatorioSemanaAtendimento(pesquisa);
				break;
			}

			}

			fechaConexao(dao);
			
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return result;
	}

	private RelatorioDao getDao(){
//		if(dao ==null)
		try {
			dao = (RelatorioDao)DAOFactory.getInstance().getDAO("pmon.dao.RelatorioDao",  getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}
		return dao;
	}
}
