package questao.acao;

import javax.servlet.http.*;

import slave.Dominio;
import acao.Acao;

public class AbrirContextoDeQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		secao.setAttribute("execucao","Cadastrar");
		Integer perfil = (Integer)secao.getAttribute("perfil");
		
		if(perfil.intValue()==Dominio.getAdministrador().intValue())
			return "/jsp/questao/menuQuestoesAdministrador.jsp";
		
		if(perfil.intValue()==Dominio.getAluno().intValue())
			return "/jsp/questao/menuQuestoesAluno.jsp";
		
		if(perfil.intValue()==Dominio.getProfessor().intValue())
			return "/jsp/questao/menuQuestoesProfessor.jsp";

		if(perfil.intValue()==Dominio.getDiretor().intValue())
			return "/jsp/questao/menuQuestoesDiretor.jsp";
		
		if(perfil.intValue()==Dominio.getMonitor().intValue())
			return "/jsp/questao/menuQuestoesMonitor.jsp";
		
		return "/ajuda.do";
	}
	
}
