package questao.acao;

import java.util.List;

import javax.servlet.http.*;

import questao.dto.*;
import questao.model.ListaModel;
import questao.model.QuestaoModel;
import questao.slave.UtilDate;
import slave.Dominio;
import slave.VisaoApoioProjetoMaior;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class AbrirResponderQuestaoAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO) req.getSession().getAttribute("loginDTO");
		String acao = req.getParameter("acao");
		String senha = req.getParameter("senha");
		QuestaoModel model = new QuestaoModel(login);
		Integer perfil = (Integer) req.getSession().getAttribute("perfil");

		QuestaoDTO dtoQuestao = new QuestaoDTO();
		ListaDTO dtoLista = new ListaDTO();
		String idListaString = req.getParameter("idLista");
		
		if (idListaString != null && !idListaString.equals("")) {
			dtoLista.setIdLista(new Integer(idListaString));
		}

		String idDisciplinaString = req.getParameter("idDisciplina");
		
		if (idDisciplinaString != null && !idDisciplinaString.equals(""))
			dtoQuestao.setIdDisciplina(new Integer(idDisciplinaString));
		
		String idConteudoString = req.getParameter("idConteudo");
		
		if (idConteudoString != null && !idConteudoString.equals(""))
			dtoQuestao.setIdConteudo(new Integer(idConteudoString));
		
		dtoQuestao.setEnunciado(req.getParameter("enunciado"));
		dtoQuestao.setTipoQuestao(req.getParameter("tipoQuestao"));
		dtoQuestao.setDificuldade(req.getParameter("dificuldade"));
		dtoQuestao.setCategoria(req.getParameter("categoria"));
		PessoaDTO pessoa = VisaoApoioProjetoMaior.carregaPessoaPeloPerfil(secao, perfil);
		String mensagem = null;
		List col = null;
		try {

			if (acao.equalsIgnoreCase("RESPONDERLISTA")) {
				ListaModel modelLista = new ListaModel(login);
				ListaDTO dtoListaTemp = modelLista.buscarLista(dtoLista.getIdLista());
			
				if ((dtoListaTemp.getChaveAcesso() == null)	|| (senha != null && senha.equals(dtoListaTemp.getChaveAcesso()))) {
					
					ListaTurmaDTO relTurmaLista = modelLista.buscaDataLimiteParaLista(dtoLista,pessoa.getChavePessoa().toString());
					
					if (login.getPerfil().intValue() != Dominio.getProfessor().intValue()) {
						
						if (relTurmaLista == null
								|| !relTurmaLista.getHorarioLimiteEntrega().after(UtilDate.getDataAtual())) {
							System.out.println(relTurmaLista.getHorarioLimiteEntrega());
							System.out.println(UtilDate.getDataAtual());
							mensagem = "Prazo de Resposta excedido!";
							throw new Exception();
						}
					}


					col = model.buscarListaDeQuestoes(dtoLista, pessoa.getChavePessoa());
					
					if (col.size() == 0) {
						
						mensagem = "Lista j respondida!!!";
						throw new Exception();
					}
				} else {
					
					if (senha != null && !senha.equals(dtoListaTemp.getChaveAcesso()))
						System.out.println("entrou no if acima... seta mensagem senha da lista invalida");
					req.setAttribute("mensagem", "Senha da lista invalida!");
					return "informaSenhaLista.do?idLista=" + idListaString;
				}
			} else {
				System.out.println("Entrando na resoluo de questoes avulsas");
				col = model.buscarListaDeQuestoes(dtoQuestao, perfil, pessoa.getChavePessoa());
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("mensagem = "+mensagem);
			if (mensagem == null)
				mensagem = Dominio.getMensagemErroNaBaseDeDados();
			req.setAttribute("mensagem", mensagem);
			if (acao.equalsIgnoreCase("RESPONDERLISTA"))
				return "/abrirPesquisaListaDaTurma.do?acao=RESPONDER";
			return "/abrirFiltroBuscaQuestao.do";
		}

		secao.setAttribute("questoes", col);

		if (col.size() < 1) {
		
			req.setAttribute("mensagemPesquisa", Dominio.getMensagemNenhumItemEncontrado());
			return "/abrirFiltroBuscaQuestao.do";
		}

		int rand = ((int) (Math.random() * col.size()));

		QuestaoDTO questao = (QuestaoDTO) col.get(rand);

		req.setAttribute("questao", questao);
		return "/jsp/questao/responderQuestao.jsp";
	}

}