package questao.acao;

import javax.servlet.http.*;

import dto.LoginDTO;

import questao.dto.*;
import questao.model.QuestaoModel;
import questao.slave.DominioTipoQuestao;
import questao.slave.UtilDate;
import questao.validacao.ValidacaoCamposQuestao;
import questao.validacao.message.MessageErrorQuestao;
import slave.Dominio;
import acao.Acao;


public class AlterarQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		HttpSession secao = req.getSession();
		MessageErrorQuestao meq = new MessageErrorQuestao();

		try{
			ValidacaoCamposQuestao.validaQuestao(req,meq);
		}catch (Exception e) {
			req.setAttribute("erro",meq);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarQuestao.do?idQuestao="+secao.getAttribute("idQuestao")+"&acao=ALTERAR";
		}
		//***********************************************************************
		QuestaoModel model = new QuestaoModel(login);
		QuestaoDTO dto = new QuestaoDTO();
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setIdConteudo(new Integer(req.getParameter("idConteudo")));
		if(req.getParameter("chavePessoa")!=null)
			dto.setChavePessoa(new Integer(req.getParameter("chavePessoa")));
		dto.setEnunciado(req.getParameter("enunciado"));
		dto.setTipoQuestao(req.getParameter("tipoQuestao"));
		dto.setDificuldade(req.getParameter("dificuldade"));
		dto.setCategoria(req.getParameter("categoria"));
		dto.setTempo(new Integer(req.getParameter("tempo")));
		if(req.getParameter("dtcriacao")!=null)
			dto.setDtcriacao(UtilDate.getData(req.getParameter("dtcriacao")));
		dto.setIdQuestao(req.getParameter("idQuestao"));
		req.removeAttribute("idQuestao");
		IComplementoQuestao complementoQuestao = criaComplementoQuestao(req, dto);
						
		try{
			model.alterarQuestao(dto,complementoQuestao);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarQuestao.do";
	}
	
	private IComplementoQuestao criaComplementoQuestao(HttpServletRequest req, QuestaoDTO dto) {
		IComplementoQuestao complementoRetorno = null;
		if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorVouF())){
			ComplementoVouFDTO dtoVouF = new ComplementoVouFDTO();
//			dtoVouF.setResposta(req.getParameter("resposta"));
			dtoVouF.setIdQuestao(new Integer(req.getParameter("idQuestao")));
			dtoVouF.setComentarioCerto(req.getParameter("comentarioCerto"));
			dtoVouF.setComentarioErrado(req.getParameter("comentarioErrado"));
			complementoRetorno = dtoVouF;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorMultiplaEscolha())){
			ComplementoMultiplaDTO dtoMultipla = new ComplementoMultiplaDTO();
//			dtoMultipla.setResposta(req.getParameter("respostaMultipla"));
			dtoMultipla.setIdQuestao(new Integer(req.getParameter("idQuestao")));
			dtoMultipla.setOpcao1(req.getParameter("opcao1"));
			dtoMultipla.setOpcao2(req.getParameter("opcao2"));
			dtoMultipla.setOpcao3(req.getParameter("opcao3"));
			dtoMultipla.setOpcao4(req.getParameter("opcao4"));
			dtoMultipla.setComentario1(req.getParameter("comentario1"));
			dtoMultipla.setComentario2(req.getParameter("comentario2"));
			dtoMultipla.setComentario3(req.getParameter("comentario3"));
			dtoMultipla.setComentario4(req.getParameter("comentario4"));
			complementoRetorno = dtoMultipla;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorEscolhaMultipla())){
			ComplementoEscolhaDTO dtoEscolha = new ComplementoEscolhaDTO();
			dtoEscolha.setIdQuestao(new Integer(req.getParameter("idQuestao")));
			dtoEscolha.setOpcao1(req.getParameter("opcao1Escolha"));
			dtoEscolha.setOpcao2(req.getParameter("opcao2Escolha"));
			dtoEscolha.setOpcao3(req.getParameter("opcao3Escolha"));
			dtoEscolha.setOpcao4(req.getParameter("opcao4Escolha"));
			dtoEscolha.setComentarioCerto(req.getParameter("comentarioCertoEscolha"));
			dtoEscolha.setComentarioErrado(req.getParameter("comentarioErradoEscolha"));
			complementoRetorno = dtoEscolha;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorLacunas())){
			ComplementoLacunaDTO dtoLacuna = new ComplementoLacunaDTO();
			dtoLacuna.setIdQuestao(new Integer(req.getParameter("idQuestao")));
			dtoLacuna.setComentarioCerto(req.getParameter("comentarioCertoLacuna"));
			dtoLacuna.setComentarioErrado(req.getParameter("comentarioErradoLacuna"));
			dtoLacuna.setFrase(req.getParameter("fraseLacuna"));
			complementoRetorno = dtoLacuna;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorDissertacao())){
			ComplementoAbertaDTO dtoAberta = new ComplementoAbertaDTO();
			dtoAberta.setIdQuestao(new Integer(req.getParameter("idQuestao")));
			dtoAberta.setResposta(req.getParameter("respostaAberta"));
			complementoRetorno = dtoAberta;
		}
		return complementoRetorno;
	}

}
