package questao.acao;

import java.util.Date;

import javax.servlet.http.*;

import questao.dto.*;
import questao.model.QuestaoModel;
import questao.slave.DominioGabaritoQuestao;
import questao.slave.DominioTipoQuestao;
import questao.validacao.ValidacaoCamposQuestao;
import questao.validacao.message.MessageErrorQuestao;
import slave.Dominio;
import slave.VisaoApoioProjetoMaior;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class CadastrarQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorQuestao meq = new MessageErrorQuestao();

		try{
			ValidacaoCamposQuestao.validaQuestao(req,meq);
		}catch (Exception e) {
			req.setAttribute("erro",meq);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarQuestao.do";
		}
		//***********************************************************************
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		QuestaoDTO dto = new QuestaoDTO();
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setIdConteudo(new Integer(req.getParameter("idConteudo")));
		dto.setEnunciado(req.getParameter("enunciado"));
		dto.setTipoQuestao(req.getParameter("tipoQuestao"));
		dto.setDificuldade(req.getParameter("dificuldade"));
		dto.setCategoria(req.getParameter("categoria"));
		dto.setTempo(new Integer(req.getParameter("tempo")));

		
	   	PessoaDTO pessoa = VisaoApoioProjetoMaior.carregaPessoaPeloPerfil(secao, perfil);
		dto.setChavePessoa(pessoa.getChavePessoa());
		dto.setDtcriacao(new Date());
		IComplementoQuestao complementoQuestao = criaComplementoQuestao(req, dto);
	
		try{
			model.cadastrarQuestao(dto,complementoQuestao);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarQuestao.do";
	}

	private IComplementoQuestao criaComplementoQuestao(HttpServletRequest req, QuestaoDTO dto) {
		IComplementoQuestao complementoRetorno = null;
		if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorVouF())){
			ComplementoVouFDTO dtoVouF = new ComplementoVouFDTO();
			dtoVouF.setResposta(req.getParameter("resposta"));
			dtoVouF.setComentarioCerto(req.getParameter("comentarioCerto"));
			dtoVouF.setComentarioErrado(req.getParameter("comentarioErrado"));
			complementoRetorno = dtoVouF;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorMultiplaEscolha())){
			ComplementoMultiplaDTO dtoMultipla = new ComplementoMultiplaDTO();
			dtoMultipla.setResposta(req.getParameter("respostaMultipla"));
			dtoMultipla.setOpcao1(req.getParameter("opcao1"));
			dtoMultipla.setOpcao2(req.getParameter("opcao2"));
			dtoMultipla.setOpcao3(req.getParameter("opcao3"));
			dtoMultipla.setOpcao4(req.getParameter("opcao4"));
			dtoMultipla.setComentario1(req.getParameter("comentario1"));
			dtoMultipla.setComentario2(req.getParameter("comentario2"));
			dtoMultipla.setComentario3(req.getParameter("comentario3"));
			dtoMultipla.setComentario4(req.getParameter("comentario4"));
			complementoRetorno = dtoMultipla;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorEscolhaMultipla())){
			ComplementoEscolhaDTO dtoEscolha = new ComplementoEscolhaDTO();
			String []respostaEscolhas = req.getParameterValues("respostaEscolha");
			int valor = 0;
			for(int i = 0; i<respostaEscolhas.length;i++){
				valor+= Integer.parseInt(respostaEscolhas[i]);
			}
			String codigoResposta = (String)DominioGabaritoQuestao.getMapaDeCodigos().get(new Integer(valor));
			
			dtoEscolha.setResposta(codigoResposta);
			dtoEscolha.setOpcao1(req.getParameter("opcao1Escolha"));
			dtoEscolha.setOpcao2(req.getParameter("opcao2Escolha"));
			dtoEscolha.setOpcao3(req.getParameter("opcao3Escolha"));
			dtoEscolha.setOpcao4(req.getParameter("opcao4Escolha"));
			dtoEscolha.setComentarioCerto(req.getParameter("comentarioCertoEscolha"));
			dtoEscolha.setComentarioErrado(req.getParameter("comentarioErradoEscolha"));
			complementoRetorno = dtoEscolha;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorLacunas())){
			ComplementoLacunaDTO dtoLacuna = new ComplementoLacunaDTO();
			dtoLacuna.setResposta(req.getParameter("respostaLacuna"));
			dtoLacuna.setRespostaAlternativa(req.getParameter("respostaAlternativaLacuna"));
			dtoLacuna.setComentarioCerto(req.getParameter("comentarioCertoLacuna"));
			dtoLacuna.setComentarioErrado(req.getParameter("comentarioErradoLacuna"));
			dtoLacuna.setFrase(req.getParameter("fraseLacuna"));
			complementoRetorno = dtoLacuna;
		}else if(dto.getTipoQuestao().equals(DominioTipoQuestao.getValorDissertacao())){
			ComplementoAbertaDTO dtoAberta = new ComplementoAbertaDTO();
			dtoAberta.setResposta(req.getParameter("respostaAberta"));
			complementoRetorno = dtoAberta;
		}
		return complementoRetorno;
	}
}
