package questao.acao;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.model.QuestaoModel;
import slave.Dominio;
import acao.Acao;


public class ListarTodasQuestoesAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		Collection col=null;
		try{
			col = model.listarTodasQuestoes();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		req.setAttribute("questoes",col);
		return "/jsp/questao/listarQuestoes.jsp";
	}

}
