package questao.acao;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.model.QuestaoModel;
import slave.Dominio;
import acao.Acao;


public class MostraExclusaoAlteracaoQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		Integer idQuestao = new Integer(req.getParameter("idQuestao"));
		try{
			req.setAttribute("questao",model.buscarQuestaoApoioQuestao(idQuestao));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		
		req.setAttribute("idQuestao",idQuestao);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/questao/alterarQuestao.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR") || req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZARQUESTAOLISTA"))
				return "/jsp/questao/visualizarQuestao.jsp";
		return "/jsp/questao/excluirQuestao.jsp";
	}
}
