package questao.acao;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.dto.QuestaoDTO;
import questao.model.QuestaoModel;
import slave.Dominio;
import acao.Acao;


public class PesquisarQuestoesAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoDTO dto = new QuestaoDTO();
		dto.setEnunciado(req.getParameter("enunciado"));
		dto.setTipoQuestao(req.getParameter("tipoQuestao"));
		dto.setDificuldade(req.getParameter("dificuldade"));
		dto.setCategoria(req.getParameter("categoria"));
		if(req.getParameter("idDisciplina")!=null && !req.getParameter("idDisciplina").equals(""))
			dto.setIdDisciplina(req.getParameter("idDisciplina"));
		if(req.getParameter("idConteudo")!=null && !req.getParameter("idConteudo").equals(""))
		dto.setIdConteudo(req.getParameter("idConteudo"));
//		String acao = req.getParameter("acao");
//		String quantidadeQuestoes = req.getParameter("quantidadeQuestoes");
//		List listaQuestoes = null;//req.getParameter("lista");
//		String idQuestao = req.getParameter("idQuestao");
		QuestaoModel model = new QuestaoModel(login);
		try{
			List listaQuestoes = model.buscarListaDeQuestoesApoioQuestao(dto);
			if(listaQuestoes.size()<1){
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			}
			req.setAttribute("questoes",listaQuestoes);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		
		return "/jsp/questao/filtroBuscaQuestao.jsp";
	}
}
