package questao.acao;

import java.util.Date;

import javax.servlet.http.*;

import questao.dto.*;
import questao.model.QuestaoModel;
import questao.model.RespostaModel;
import questao.slave.*;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class ResponderQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String acao=req.getParameter("acao");
		IResposta dtoResposta = null;
		IRespostaLista dtoRespostaLista = null;
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		RespostaModel model = new RespostaModel(login);
		String tipoQuestao = req.getParameter("tipoQuestaoControle");
		String solucao = null;
		
		if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorVouF())){
			solucao = req.getParameter("solucao");
		}else if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorMultiplaEscolha())){
			solucao = req.getParameter("solucaoMultipla");
		}else if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorEscolhaMultipla())){
			String [] solucaoEscolha = req.getParameterValues("solucaoEscolha");
			int soma=0;
			for(int i=0; i<solucaoEscolha.length; i++){
				soma+=Integer.parseInt(solucaoEscolha[i]);
			}
			String codigoResposta = (String)DominioGabaritoQuestao.getMapaDeCodigos().get(new Integer(soma));
			solucao = codigoResposta;			
		}else if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorLacunas())){
			solucao = req.getParameter("solucaoLacuna");
		}else if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorDissertacao())){
			solucao = req.getParameter("solucaoAberta");
		}
		
		if(!acao.equalsIgnoreCase("RESPONDERLISTA")){
			if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorLacunas()) || tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorDissertacao())){
				try {
					dtoResposta = new RespostaAlunoAvulsa_AbertaDTO();
					carregaRespostaAvulsa(dtoResposta, req, solucao);
				} catch (Throwable e1) {
					e1.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
					return "/abrirPesquisarQuestao.do";
				}
				
				try{
					if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorLacunas())){
						QuestaoModel questaoModel = new QuestaoModel(login);
						ComplementoLacunaDTO respostaCadastrada = questaoModel.buscaComplementoLacuna(((RespostaAlunoAvulsa_AbertaDTO)dtoResposta).getIdQuestao());
						if(respostaCadastrada.getResposta().equals(((RespostaAlunoAvulsa_AbertaDTO)dtoResposta).getSolucao()))
							((RespostaAlunoAvulsa_AbertaDTO)dtoResposta).setCorrecao(DominioCorrecaoQuestao.valorCorreta);
						else
							((RespostaAlunoAvulsa_AbertaDTO)dtoResposta).setCorrecao(DominioCorrecaoQuestao.valorErrada);
					}else
						((RespostaAlunoAvulsa_AbertaDTO)dtoResposta).setCorrecao(DominioCorrecaoQuestao.valorAguardandoCorrecao);
							
					model.cadastrarResposta_Aberta((RespostaAlunoAvulsa_AbertaDTO)dtoResposta);
				}catch (Exception e) {
					e.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisarQuestao.do";
				}
			}else{
				try {
					dtoResposta = new RespostaAlunoAvulsaDTO();
					carregaRespostaAvulsa(dtoResposta, req, solucao);

				} catch (Throwable e1) {
					e1.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
					return "/abrirPesquisarQuestao.do";
				}
				
				try{
					model.cadastrarResposta((RespostaAlunoAvulsaDTO)dtoResposta);
				}catch (Exception e) {
					e.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisarQuestao.do";
				}
			}
			QuestaoModel modelQuestao = new QuestaoModel(login);
			QuestaoDTO dtoQuestao = modelQuestao.buscarQuestao(dtoResposta.getIdQuestao());
			
			req.setAttribute("questao", dtoQuestao);
			req.setAttribute("resposta", dtoResposta);
		}else{//se for uma lista
			if( tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorLacunas()) || tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorDissertacao() )){
				try {
					dtoRespostaLista = new RespostaAlunoLista_AbertaDTO();
					carregaRespostaLista(dtoRespostaLista, req, solucao);
				} catch (Throwable e1) {
					e1.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
					return "/abrirPesquisaListaQuestoes.do";
				}
				
				try{
					if(tipoQuestao.equalsIgnoreCase(DominioTipoQuestao.getValorLacunas())){
						//((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).setCorrecao(DominioCorrecaoQuestao.valorSemCorrecao);
						QuestaoModel questaoModel = new QuestaoModel(login);

						ComplementoLacunaDTO respostaCadastrada = questaoModel.buscaComplementoLacuna(((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).getIdQuestao());
						System.out.println("resposta do banco: "+respostaCadastrada.getResposta());
						System.out.println("resposta do sistema: "+((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).getSolucao());
						
						if((respostaCadastrada.getResposta().equals(((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).getSolucao()))||(respostaCadastrada.getRespostaAlternativa().equals(((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).getSolucao())))
							((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).setCorrecao(DominioCorrecaoQuestao.valorCorreta);
						else
							((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).setCorrecao(DominioCorrecaoQuestao.valorErrada);
					}else
						((RespostaAlunoLista_AbertaDTO)dtoRespostaLista).setCorrecao(DominioCorrecaoQuestao.valorAguardandoCorrecao);
							
					
					model.cadastrarRespostaLista_Aberta((RespostaAlunoLista_AbertaDTO)dtoRespostaLista);
				}catch (Exception e) {
					e.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisaListaQuestoes.do";
				}
			}else{
				try {
					dtoRespostaLista = new RespostaAlunoListaDTO();
					carregaRespostaLista(dtoRespostaLista, req, solucao);
				} catch (Throwable e1) {
					e1.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
					return "/abrirPesquisaListaQuestoes.do";
				}
				
				try{
						model.cadastrarRespostaLista((RespostaAlunoListaDTO)dtoRespostaLista);
				}catch (Exception e) {
					e.printStackTrace();
					req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisaListaQuestoes.do";
				}
			}
			QuestaoModel modelQuestao = new QuestaoModel(login);
			QuestaoDTO dtoQuestao = modelQuestao.buscarQuestao(dtoRespostaLista.getIdQuestao());
			
			req.setAttribute("questao", dtoQuestao);
			req.setAttribute("resposta", dtoRespostaLista);
		}
		return "/abrirGabaritoQuestao.do";
	}

	private void carregaPessoa(HttpSession secao, Integer perfil, PessoaDTO pessoa) throws Throwable {
		ObjetoStrategy strategy = new ObjetoStrategy(this);
		strategy.addElemento(new ElementoPerfilAdministrador(perfil,pessoa,secao));
		strategy.addElemento(new ElementoPerfilAluno(perfil,pessoa,secao));
		strategy.addElemento(new ElementoPerfilDiretor(perfil,pessoa,secao));
		strategy.addElemento(new ElementoPerfilMonitor(perfil,pessoa,secao));
		strategy.addElemento(new ElementoPerfilProfessor(perfil,pessoa,secao));
		strategy.executaVerificacaoNaoAninhada();
	}
	
	private void carregaRespostaLista(IRespostaLista dtoResposta, HttpServletRequest req, String solucao) throws Throwable {
		HttpSession secao = req.getSession();
		dtoResposta.setIdLista(new Integer(req.getParameter("idLista")));
		dtoResposta.setIdQuestao(new Integer(req.getParameter("idQuestao")));
		dtoResposta.setSolucao(solucao);
		dtoResposta.setTempoSolucao(new Integer(req.getParameter("tempoSolucao")));
		dtoResposta.setDtSolucao(new Date());
		dtoResposta.setHorarioSolucao(new Date());
		Integer perfil = (Integer)secao.getAttribute("perfil");
	   	PessoaDTO pessoa = new PessoaDTO();
		carregaPessoa(secao, perfil, pessoa);
		dtoResposta.setChavePessoa(pessoa.getChavePessoa());
	}
	
	private void carregaRespostaAvulsa(IResposta dtoResposta, HttpServletRequest req, String solucao) throws Throwable {
		HttpSession secao = req.getSession();
		dtoResposta.setIdQuestao(new Integer(req.getParameter("idQuestao")));
		dtoResposta.setSolucao(solucao);
		dtoResposta.setTempoSolucao(new Integer(req.getParameter("tempoSolucao")));
		dtoResposta.setDtSolucao(new Date());
		dtoResposta.setHorarioSolucao(new Date());
		Integer perfil = (Integer)secao.getAttribute("perfil");
	   	PessoaDTO pessoa = new PessoaDTO();
		carregaPessoa(secao, perfil, pessoa);
		dtoResposta.setChavePessoa(pessoa.getChavePessoa());
	}	
}
