package questao.acao.lista;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.dto.QuestaoDTO;
import questao.model.QuestaoModel;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;


public class AdicionaQuestaoManualmenteNaListaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String quantidadeQuestoes = req.getParameter("quantidadeQuestoes");
		List listaQuestoes = null;
		String idQuestao = req.getParameter("idQuestao");
		idQuestao = validaIdQuestao(idQuestao);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		QuestaoDTO dto = null;
		
		try {
			listaQuestoes = recuperaLista(req);
		} catch (SQLException e) {
			String mensagem = (String)req.getAttribute("mensagem");
			if(mensagem==null || mensagem.equals(""))
				mensagem=Dominio.getMensagemErroNaBaseDeDados(); 
			req.setAttribute("mensagem",mensagem);
			return "/adicionaQuestaoManualmenteNaLista.do";
		}
		
		if(idQuestao!=null && quantidadeQuestoes!=null && listaQuestoes!=null){
			boolean isQuestaoJaNaLista;
			int quantidadeQuestoesInt;
			
			try {
				dto = model.buscarQuestao(new Integer(idQuestao));
			} catch (SQLException e) {
				String mensagem = (String)req.getAttribute("mensagem");
				if(mensagem==null || mensagem.equals(""))
					mensagem=Dominio.getMensagemErroNaBaseDeDados(); 
				req.setAttribute("mensagem",mensagem);
				return "/adicionaQuestaoManualmenteNaLista.do";
			}
			
			quantidadeQuestoesInt = Integer.parseInt(quantidadeQuestoes);
			isQuestaoJaNaLista = isQuestaoNaLista(listaQuestoes,dto);
			
			if(listaQuestoes.size()<quantidadeQuestoesInt && !isQuestaoJaNaLista){
				listaQuestoes.add(dto);
			}else if(isQuestaoJaNaLista){
				String mensagem = (String)req.getAttribute("mensagem");
				if(mensagem==null || mensagem.equals(""))
					mensagem="Questo j adicionada!"; 
				req.setAttribute("mensagem",mensagem);
			}else{
				String mensagem = (String)req.getAttribute("mensagem");
				if(mensagem==null || mensagem.equals(""))
					mensagem="Nmero de questes excedido!"; 
				req.setAttribute("mensagem",mensagem);
			}
				
		}		
		req.setAttribute("lista", listaQuestoes);
		return "/jsp/questao/lista/editaListaManualmente.jsp";
	}
	
	private String validaIdQuestao(String idQuestao) {
		if(idQuestao!=null && idQuestao.equalsIgnoreCase("null"))
			idQuestao=null;
		return idQuestao;
	}

	private boolean isQuestaoNaLista(List listaQuestao, QuestaoDTO questao){
		Iterator it = listaQuestao.iterator();
		QuestaoDTO questaoTemp=null;
		while(it.hasNext()){
			questaoTemp = (QuestaoDTO)it.next();
			if(questaoTemp.getIdQuestao().intValue() == questao.getIdQuestao().intValue())
				return true;
		}
		return false;
	}
	
	public List recuperaLista(HttpServletRequest req) throws Exception{
		return VisaoQuestao.recuperaLista(req);
	}

}
