package questao.acao.lista;

import java.util.Date;
import java.util.List;

import javax.servlet.http.*;

import questao.dto.ListaDTO;
import questao.model.ListaModel;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import slave.VisaoApoioProjetoMaior;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class CadastrarListaQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ListaModel model = new ListaModel(login);
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		
		ListaDTO dto = new ListaDTO();
		List listaQuestoes = VisaoQuestao.recuperaLista(req);
		
		dto.setTituloLista(req.getParameter("tituloLista"));
		dto.setCategoria(req.getParameter("categoria"));
		dto.setQuantidadeQuestoes(new Integer(req.getParameter("quantidadeQuestoes")));
		dto.setChaveAcesso(req.getParameter("chaveAcesso"));
		
	   	PessoaDTO pessoa = VisaoApoioProjetoMaior.carregaPessoaPeloPerfil(secao, perfil);
		
		dto.setChavePessoaProfessor(pessoa.getChavePessoa());
		dto.setDtCriacao(new Date());
	
		try{
			if(dto.getQuantidadeQuestoes().intValue()!=listaQuestoes.size()){
				req.setAttribute("mensagem","A lista deve ter "+dto.getQuantidadeQuestoes()+" questes!");
				return "/adicionaQuestaoManualmenteNaLista.do";
			}
			if(dto.getChaveAcesso().length() < 4)
			{
				req.setAttribute("mensagem","A chave de acesso precisa ter pelo menos 4 caracteres!");
				return "/configuraCriacaoDaLista.do";
			}
			model.cadastrarLista(dto,listaQuestoes);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisaListaQuestoes.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisaListaQuestoes.do";
	}

}
