package questao.acao.lista;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import questao.dto.QuestaoDTO;
import questao.model.QuestaoModel;
import questao.validacao.ValidacaoCamposLista;
import questao.validacao.message.MessageErrorLista;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;


public class ConfiguraCriacaoDaListaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		MessageErrorLista meq = new MessageErrorLista();

		try{
			ValidacaoCamposLista.validaLista(req,meq);
		}catch (Exception e) {
			req.setAttribute("erro",meq);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirTelaCriaListaQuestao.do";
		}
		//***********************************************************************
		Integer quantidadeQuestoes = new Integer(req.getParameter("quantidadeQuestoes"));
		
		if(quantidadeQuestoes.intValue() > getQuantidadeDeQuestoesDaLista(req)){
			req.setAttribute("mensagem","O nmero de questes cadastradas no sistema  insuficiente para criar uma lista desse tipo!");
			return "/abrirTelaCriaListaQuestao.do";
		}
		
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("MANUALMENTE"))
			return "/jsp/questao/lista/editaListaManualmente.jsp";
		return "/geraListaAutomaticamente.do";
	}
	
	public int getQuantidadeDeQuestoesDaLista(HttpServletRequest req) throws SQLException{
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoDTO questaoTemp = new QuestaoDTO();
		questaoTemp.setIdDisciplina(req.getParameter("idDisciplina"));
		QuestaoModel model = new QuestaoModel(login);
		return model.buscarQuantidadeListaDeQuestoes(questaoTemp);
    }
}
