package questao.acao.lista;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;
import dto.TurmaDTO;

import questao.model.ListaModel;
import slave.Dominio;
import acao.Acao;


public class ExcluirListaQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ListaModel model = new ListaModel(login);
		Integer idLista = new Integer(req.getParameter("idLista"));
		String codigoTurma = req.getParameter("codigoTurma");
		String codigoCurso = req.getParameter("codigoCurso");
		String idDisciplina = req.getParameter("idDisciplina");
		String semestre = req.getParameter("semestre");
		String ano = req.getParameter("ano");
		
		try{
			if(codigoTurma!=null && codigoCurso!=null && idDisciplina!=null && semestre!=null && ano!=null){
				TurmaDTO turmaTemp = new TurmaDTO();
				turmaTemp.setCodigoTurma(codigoTurma);
				turmaTemp.setCodigoCurso(new Integer(codigoCurso));
				turmaTemp.setIdDisciplina(new Integer(idDisciplina));
				turmaTemp.setSemestre(semestre);
				turmaTemp.setAno(new Integer(ano));
				model.excluirListaDaTurma(idLista, turmaTemp);
			}else{
				model.excluir(idLista);
			}
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisaListaQuestoes.do";
		}
		
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisaListaQuestoes.do";
	}

}
