package questao.acao.lista;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import questao.dto.QuestaoDTO;
import questao.model.QuestaoModel;
import questao.slave.*;
import acao.Acao;
import dto.LoginDTO;

public class GeraListaAutomaticamenteAcao implements Acao {

	private String tituloLista;
	private String categoria;
	private String quantidadeQuestoesString;
	private List listaQuestoes;
	private Integer idDisciplina;

	public List getListaQuestoes() {
		if(this.listaQuestoes==null)
			this.listaQuestoes = new ArrayList();
		return this.listaQuestoes;
	}
	
	public void setListaQuestoes(List listaQuestoes) {
		this.listaQuestoes = listaQuestoes;
	}
	
	public String getCategoria() {
		return this.categoria;
	}

	public void setCategoria(String categoria) {
		this.categoria = categoria;
	}

	public String getQuantidadeQuestoesString() {
		return this.quantidadeQuestoesString;
	}

	public void setQuantidadeQuestoesString(String quantidadeQuestoesString) {
		this.quantidadeQuestoesString = quantidadeQuestoesString;
	}

	public String getTituloLista() {
		return this.tituloLista;
	}

	public void setTituloLista(String tituloLista) {
		this.tituloLista = tituloLista;
	}
	public Integer getIdDisciplina() {
		return this.idDisciplina;
	}
	public void setIdDisciplina(Integer idDisciplina) {
		this.idDisciplina = idDisciplina;
	}

	public String executar(HttpServletRequest req, HttpServletResponse resp){
		setTituloLista(req.getParameter("tituloLista"));
		setCategoria(req.getParameter("categoria"));
		setQuantidadeQuestoesString(req.getParameter("quantidadeQuestoes"));
		setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		
//		ObjetoStrategy strategy = new ObjetoStrategy(this);
//		strategy.addElemento(new ElementoListaFixacao());
//		strategy.addElemento(new ElementoListaRevisao());
//		strategy.addElemento(new ElementoListaAvaliativa());
//		strategy.executaVerificacaoNaoAninhada();
		
		//TODO: usar o strategy
		Questionario questionarioQuestoes=null;
		if(this.getCategoria().equals(DominioCategoriaQuestao.getValorFixacao())){
			questionarioQuestoes = new QuestionarioDeFixacao(req);
		}
		
		if(this.getCategoria().equals(DominioCategoriaQuestao.getValorRevisao())){
			questionarioQuestoes = new QuestionarioDeRevisao(req);
			
		}
		if(this.getCategoria().equals(DominioCategoriaQuestao.getValorAvaliativa())){
			questionarioQuestoes = new QuestionarioDeAvaliacao(req);
		}
		
		questionarioQuestoes.setQuantidadeDeQuestoes(Integer.parseInt(getQuantidadeQuestoesString()));
		try {
			setListaQuestoes(questionarioQuestoes.getQuestionario(getCategoria(),getIdDisciplina()));
		} catch (Exception e1) {
			req.setAttribute("mensagem", "No  possivel criar a lista! O nmero de questes deve estar inferior ao necessrio.");
			return "/abrirFiltroBuscaQuestao.do";
		}
		
//		try {
//			listaQuestoes = (List) model.buscarListaDeQuestoes(dto);
//		} catch (Exception e) {
//			req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
//			return "/abrirFiltroBuscaQuestao.do";
//		}
//		req.setAttribute("questoes", listaQuestoes);

//		int rand = ((int) (Math.random() * listaQuestoes.size()));
//		QuestaoDTO questao = (QuestaoDTO) listaQuestoes.get(rand);
//		req.setAttribute("questao", questao);
		
		req.setAttribute("lista", getListaQuestoes());
		req.setAttribute("quantidadeQuestoes", getQuantidadeQuestoesString());
		return "/jsp/questao/lista/editaListaManualmente.jsp";
	}

	
}

//TODO: rever esses valores para cada tipo de lista
//Fixacao= Fixacao70%(40% facil / 40% medio / 20% dificil)  ##  Revisao30% (30% facil / 40% medio / 30% dificil)
//Revisao= Revisao70% (30% facil / 40% medio / 30% dificil) ## Fixacao30%(40% facil / 40% medio / 20% dificil)
//Avaliativa= Avaliativa50% (20% facil / 50% medio / 30% dificil) ## Fixacao25%(40% facil / 40% medio / 20% dificil)  ##  Revisao25% (30% facil / 40% medio / 30% dificil)


abstract class GrupoDeQuestoes {
	protected List listaDeQuestoes;
	private LoginDTO login;
	private QuestaoModel modelQuestao;
	
    private int quantidadeDeQuestoes;
    abstract float getPorcentagemFaceis();
    abstract float getPorcentagemMedias();
    abstract float getPorcentagemDificeis();
    
    public GrupoDeQuestoes(HttpServletRequest req){
    	LoginDTO loginTemp = (LoginDTO)req.getSession().getAttribute("loginDTO");
    	this.modelQuestao = new QuestaoModel(loginTemp);
    	setLogin(loginTemp);
    }
    
    public List getListaDeQuestoes(String categoria, Integer idDisciplina) throws SQLException {
        return this.listaDeQuestoes;
    }
    public void setListaDeQuestoes(List listaDeQuestoes) {
        this.listaDeQuestoes = listaDeQuestoes;
    }
    public List getQuestoesFaceis(String categoria, Integer idDisciplina) throws SQLException{
        int tamanhoDaLista = Math.round(getQuantidadeDeQuestoes()*getPorcentagemFaceis());
        return geraListaDeQuestoes(tamanhoDaLista, DominioDificuldadeQuestao.getValorFacil(), categoria, idDisciplina);  //trocar valor por Dominio
    }
    public List getQuestoesMedias(String categoria, Integer idDisciplina) throws SQLException{
        int tamanhoDaLista = Math.round(getQuantidadeDeQuestoes()*getPorcentagemMedias());
        return geraListaDeQuestoes(tamanhoDaLista, DominioDificuldadeQuestao.getValorMediano(), categoria, idDisciplina);  //trocar valor por Dominio
    }
    public List getQuestoesDificeis(String categoria, Integer idDisciplina) throws SQLException{
        int tamanhoDaLista = Math.round(getQuantidadeDeQuestoes()*getPorcentagemDificeis());
        return geraListaDeQuestoes(tamanhoDaLista, DominioDificuldadeQuestao.getValorDificil(), categoria, idDisciplina);  //trocar valor por Dominio
    }
    private List geraListaDeQuestoes(int tamanhoDaLista, String dificuldade,String categoria, Integer idDisciplina) throws SQLException{
        List lista = new ArrayList();
//        Iterator iter = getListaDeQuestoes().iterator();
        int contadorLoops=0;
        int contadorAdicionadas=0;
       	int numRand;
        while (contadorAdicionadas < tamanhoDaLista  && contadorLoops<getListaDeQuestoes(categoria,idDisciplina).size()) {
        	numRand = (int)(Math.random()*getListaDeQuestoes(categoria,idDisciplina).size());
            QuestaoDTO questaoTemp = (QuestaoDTO)getListaDeQuestoes(categoria,idDisciplina).get(numRand);
            if(questaoTemp.getDificuldade().equals(dificuldade) && !lista.contains(questaoTemp)){
            	lista.add(questaoTemp);
            	contadorAdicionadas++;
            }
            contadorLoops++;
        }
        return lista;
    }
    private List geraListaDeQuestoes(int tamanhoDaLista, String categoria, Integer idDisciplina) throws Exception{
        List lista = new ArrayList();
        int [] vetorDeIndexInseridos = new int[tamanhoDaLista];
        int contadorLoops=0;
        int contadorAdicionadas=0;
       	int numRand;
        reinicializaVetorDeValores(vetorDeIndexInseridos);
        
        while (contadorAdicionadas < tamanhoDaLista  && contadorLoops<getListaDeQuestoes(categoria,idDisciplina).size()) {
//        	if(getListaDeQuestoes(categoria,idDisciplina).size()>tamanhoDaLista){
	        	numRand = (int)(Math.random()*getListaDeQuestoes(categoria,idDisciplina).size());
	        	while(isNumRandJaAdicionado(vetorDeIndexInseridos, numRand)){
	        		numRand = (int)(Math.random()*getListaDeQuestoes(categoria,idDisciplina).size());
	        	}
	            QuestaoDTO questaoTemp = (QuestaoDTO)getListaDeQuestoes(categoria,idDisciplina).get(numRand);
	            if(!lista.contains(questaoTemp)){
	            	lista.add(questaoTemp);
		        	vetorDeIndexInseridos[contadorAdicionadas]=numRand;
	            	contadorAdicionadas++;
	            }
	            contadorLoops++;
//        	}
        }
//        if(getListaDeQuestoes(categoria,idDisciplina).size()==tamanhoDaLista){
//    		lista.addAll((getListaDeQuestoes(categoria,idDisciplina)));
//    	}
        
        if(getListaDeQuestoes(categoria,idDisciplina).size()<tamanhoDaLista){
    		throw new Exception();
    	}
        return lista;
    }
    
    private void reinicializaVetorDeValores(int[] vetorDeIndexInseridos) {
		for(int i=0;i<vetorDeIndexInseridos.length;i++){
        	vetorDeIndexInseridos[i]=-1;
        }
	}
	public boolean isNumRandJaAdicionado(int [] vetorDeIndexInseridos,int numRand){
    	for(int i=0;i<vetorDeIndexInseridos.length;i++){
    		if(vetorDeIndexInseridos[i]==numRand)
    			return true;
    	}
    	return false;
    }
    
    public int getQuantidadeDeQuestoes() {
        return this.quantidadeDeQuestoes;
    }
    public void setQuantidadeDeQuestoes(int quantidadeDeQuestoes) {
        this.quantidadeDeQuestoes = quantidadeDeQuestoes;
    }
    public List getGrupoDeQuestoes(String categoria,Integer idDisciplina) throws Exception{
        List lista = new ArrayList();
//        lista.addAll(getQuestoesFaceis(categoria, idDisciplina));
//        lista.addAll(getQuestoesMedias(categoria, idDisciplina));
//        lista.addAll(getQuestoesDificeis(categoria, idDisciplina));
        lista.addAll(geraListaDeQuestoes(this.quantidadeDeQuestoes, categoria, idDisciplina));
        return lista;
    }
	public QuestaoModel getModelQuestao() {
		if(this.modelQuestao==null){
			this.modelQuestao = new QuestaoModel(getLogin());
		}
		return this.modelQuestao;
	}
	public void setModelQuestao(QuestaoModel modelQuestao) {
		this.modelQuestao = modelQuestao;
	}
	public LoginDTO getLogin() {
		return this.login;
	}
	public void setLogin(LoginDTO login) {
		this.login = login;
	}
}

class GrupoDeQuestoesFixacao extends GrupoDeQuestoes{
	public GrupoDeQuestoesFixacao(HttpServletRequest req){
		super(req);
	}
	
	public List getListaDeQuestoes(String categoria, Integer idDisciplina) throws SQLException{
		if(this.listaDeQuestoes==null){
			QuestaoDTO questaoTemp = new QuestaoDTO();
			questaoTemp.setCategoria(DominioCategoriaQuestao.getValorFixacao());
			questaoTemp.setIdDisciplina(idDisciplina);
			try{
				this.listaDeQuestoes=getModelQuestao().buscarListaDeQuestoes(questaoTemp);
			}catch (Exception e) {
				e.printStackTrace();
				return new ArrayList();
			}
		}
        return this.listaDeQuestoes;
    }
    public void setListaDeQuestoes(List listaDeQuestoes) {
        super.setListaDeQuestoes(listaDeQuestoes);
    }
    float getPorcentagemFaceis() {
        return 0.4f;
    }
    float getPorcentagemMedias() {
        return 0.4f;
    }
    float getPorcentagemDificeis() {
        return 0.2f;
    }
}

class GrupoDeQuestoesRevisao extends GrupoDeQuestoes{
	public GrupoDeQuestoesRevisao(HttpServletRequest req){
		super(req);
	}
	
	public List getListaDeQuestoes(String categoria, Integer idDisciplina) {
		if(this.listaDeQuestoes==null){
			QuestaoDTO questaoTemp = new QuestaoDTO();
			questaoTemp.setCategoria(DominioCategoriaQuestao.getValorRevisao());
			questaoTemp.setIdDisciplina(idDisciplina);
			try{
				this.listaDeQuestoes=getModelQuestao().buscarListaDeQuestoes(questaoTemp);
			}catch (Exception e) {
				e.printStackTrace();
				return new ArrayList();
			}
		}
        return this.listaDeQuestoes;
    }
    public void setListaDeQuestoes(List listaDeQuestoes) {
        super.setListaDeQuestoes(listaDeQuestoes);
    }
    float getPorcentagemFaceis() {
        return 0.3f;
    }
    float getPorcentagemMedias() {
        return 0.4f;
    }
    float getPorcentagemDificeis() {
        return 0.3f;
    }
}

class GrupoDeQuestoesAvaliacao extends GrupoDeQuestoes{
	public GrupoDeQuestoesAvaliacao(HttpServletRequest req){
		super(req);
	}
	
	public List getListaDeQuestoes(String categoria, Integer idDisciplina) {
		if(this.listaDeQuestoes==null){
			QuestaoDTO questaoTemp = new QuestaoDTO();
			questaoTemp.setCategoria(DominioCategoriaQuestao.getValorAvaliativa());
			questaoTemp.setIdDisciplina(idDisciplina);
			try{
				this.listaDeQuestoes=getModelQuestao().buscarListaDeQuestoes(questaoTemp);
			}catch (Exception e) {
				e.printStackTrace();
				return new ArrayList();
			}
		}
        return this.listaDeQuestoes;
    }
    public void setListaDeQuestoes(List listaDeQuestoes) {
        super.setListaDeQuestoes(listaDeQuestoes);
    }
    float getPorcentagemFaceis() {
        return 0.2f;
    }
    float getPorcentagemMedias() {
        return 0.5f;
    }
    float getPorcentagemDificeis() {
        return 0.3f;
    }
}

abstract class Questionario {
	private int quantidadeDeQuestoes;
	private HttpServletRequest request;
	
	public Questionario(HttpServletRequest req){
		this.request = req;
	}
    
    public abstract int getPorcentagemFixacao(int i);
    public abstract int getPorcentagemRevisao(int i);
    public abstract int getPorcentagemAvaliacao(int i);
    
    public int getQuantidadeDeQuestoes() {
        return this.quantidadeDeQuestoes;
    }
    public void setQuantidadeDeQuestoes(int quantidadeDeQuestoes) {
        this.quantidadeDeQuestoes = quantidadeDeQuestoes;
    }
    private List getQuestoesFixacao(String categoria,Integer idDisciplina) throws Exception {
        GrupoDeQuestoes grupo = new GrupoDeQuestoesFixacao(this.request);
        grupo.setQuantidadeDeQuestoes(getPorcentagemFixacao(getQuantidadeDeQuestoes()));
        return grupo.getGrupoDeQuestoes(DominioCategoriaQuestao.getValorFixacao(),idDisciplina);
    }
    private List getQuestoesRevisao(String categoria,Integer idDisciplina) throws Exception {
        GrupoDeQuestoes grupo = new GrupoDeQuestoesRevisao(this.request);
        grupo.setQuantidadeDeQuestoes(getPorcentagemRevisao(getQuantidadeDeQuestoes()));
        return grupo.getGrupoDeQuestoes(DominioCategoriaQuestao.getValorRevisao(),idDisciplina);
    }
    private List getQuestoesAvaliacao(String categoria,Integer idDisciplina) throws Exception {
        GrupoDeQuestoes grupo = new GrupoDeQuestoesAvaliacao(this.request);
        grupo.setQuantidadeDeQuestoes(getPorcentagemAvaliacao(getQuantidadeDeQuestoes()));
        return grupo.getGrupoDeQuestoes(DominioCategoriaQuestao.getValorAvaliativa(),idDisciplina);
    }
    public List getQuestionario(String categoria, Integer idDisciplina) throws Exception{
        List questionario = new ArrayList();
        questionario.addAll(getQuestoesFixacao(categoria,idDisciplina));
        questionario.addAll(getQuestoesRevisao(categoria,idDisciplina));
        questionario.addAll(getQuestoesAvaliacao(categoria,idDisciplina));
        return questionario;
    }
}

class QuestionarioDeFixacao extends Questionario{
	public QuestionarioDeFixacao(HttpServletRequest req){
		super(req);
	}
	
    public int getPorcentagemFixacao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 6;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 24;
    	else 
    		return 60;
    }
    public int getPorcentagemRevisao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 4;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 16;
    	else 
    		return 40;
    }
    public int getPorcentagemAvaliacao(int i) {
        return 0;
    }
}

class QuestionarioDeRevisao extends Questionario{
	public QuestionarioDeRevisao(HttpServletRequest req){
		super(req);
	}
	
    public int getPorcentagemFixacao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 3;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 16;
    	else 
    		return 30;
    }
    public int getPorcentagemRevisao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 7;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 28;
    	else 
    		return 70;
    }
    public int getPorcentagemAvaliacao(int i) {
        return 0;
    }
}

class QuestionarioDeAvaliacao extends Questionario{
	public QuestionarioDeAvaliacao(HttpServletRequest req){
		super(req);
	}
	
    public int getPorcentagemFixacao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 1;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 3;
    	else 
    		return 10;
    }
    public int getPorcentagemRevisao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 2;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 7;
    	else 
    		return 20;
    }
    public int getPorcentagemAvaliacao(int i) {
    	if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaPequena()))
    		return 7;
    	else if(i==Integer.parseInt(DominioQuantidadeQuestao.getValorListaMedia()))
    		return 30;
    	else 
    		return 70;
    }
}



//class ElementoListaFixacao extends ElementoStrategy {
//	private List listaQuestoesFixacao;
//	
//	public List getListaQuestoesFixacao() {
//		if(this.listaQuestoesFixacao==null)
//			this.listaQuestoesFixacao = new ArrayList();
//		return this.listaQuestoesFixacao;
//	}
//	
//	public void setListaQuestoesFixacao(List listaQuestoesFixacao) {
//		this.listaQuestoesFixacao = listaQuestoesFixacao;
//	}
//	
//	public void executa() {
//		int totalQuestoes = Integer.parseInt(((GeraListaAutomaticamenteAcao) getObjetoCliente()).getQuantidadeQuestoesString());
//		int numFixacao = (int) (totalQuestoes * 0.7);
//		int numRevisao = (int) (totalQuestoes * 0.3);
//		
//		
//	}
//	
//	public boolean condicao() {
//		return ((GeraListaAutomaticamenteAcao) getObjetoCliente()).getCategoria().equals(
//				DominioCategoriaQuestao.getValorFixacao());
//	}
//}


//class ElementoListaRevisao extends ElementoStrategy {
//	public boolean condicao() {
//		return ((GeraListaAutomaticamenteAcao) getObjetoCliente()).getCategoria().equals(
//				DominioCategoriaQuestao.getValorRevisao());
//	}
//
//	public void executa() {
//		System.out.println("Elemento2");
//	}
//}


//class ElementoListaAvaliativa extends ElementoStrategy {
//	public boolean condicao() {
//		return ((GeraListaAutomaticamenteAcao) getObjetoCliente()).getCategoria().equals(
//				DominioCategoriaQuestao.getValorAvaliativa());
//	}
//
//	public void executa() {
//		System.out.println("Elemento2");
//	}
//}


