package questao.acao.lista;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;
import dto.TurmaDTO;

import questao.model.ListaModel;
import slave.Dominio;
import acao.Acao;


public class MostraExclusaoAlteracaoListaQuestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ListaModel model = new ListaModel(login);
		Integer idLista = new Integer(req.getParameter("idLista"));
		
		String codigoTurma = req.getParameter("codigoTurma");
		String codigoCurso = req.getParameter("codigoCurso");
		String idDisciplina = req.getParameter("idDisciplina");
		String semestre = req.getParameter("semestre");
		String ano = req.getParameter("ano");
		
		try{
			req.setAttribute("lista",model.buscarListaApoioLista(idLista));
			
			if(codigoTurma!=null && codigoCurso!=null && idDisciplina!=null && semestre!=null && ano!=null){
				TurmaDTO turmaTemp = new TurmaDTO();
				turmaTemp.setCodigoTurma(codigoTurma);
				turmaTemp.setCodigoCurso(new Integer(codigoCurso));
				turmaTemp.setIdDisciplina(new Integer(idDisciplina));
				turmaTemp.setSemestre(semestre);
				turmaTemp.setAno(new Integer(ano));
				
				req.setAttribute("listaTurma",model.buscarListaDaTurmaPorId(idLista.toString(),turmaTemp));
			}
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarListaQuestao.do";
		}
		
		req.setAttribute("idLista",idLista);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/questao/lista/alterarListaQuestao.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/questao/lista/visualizarListaQuestao.jsp";
		return "/jsp/questao/lista/excluirListaQuestao.jsp";
	}
}
