package questao.acao.lista;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import questao.model.ListaModel;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;
import dto.*;
import dto.PessoaDTO;
import dto.TurmaDTO;


public class PesquisarListaDaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TurmaDTO dtoTurma = new TurmaDTO();
		dtoTurma.setCodigoTurma(req.getParameter("codigoTurma"));
		Integer perfil = (Integer)secao.getAttribute("perfil");
		PessoaDTO pessoa = VisaoQuestao.carregaPessoaPeloPerfil(secao,perfil);
		
		String codigoCurso = req.getParameter("codigoCurso");
		if(codigoCurso!=null && !codigoCurso.equals(""))
			dtoTurma.setCodigoCurso(new Integer(codigoCurso));
		
		String idDisciplina = req.getParameter("idDisciplina");
		if(idDisciplina!=null && !idDisciplina.equals(""))
			dtoTurma.setIdDisciplina(new Integer(idDisciplina));
		
		String ano = req.getParameter("ano");
		if(ano!=null && !ano.equals(""))
			dtoTurma.setAno(new Integer(ano));
		dtoTurma.setSemestre(req.getParameter("semestre"));
		
		ListaModel model = new ListaModel(login);
		try{
			Collection colecao = new ArrayList();
			if(dtoTurma.getCodigoCurso()!=null && dtoTurma.getCodigoTurma()!=null && dtoTurma.getIdDisciplina()!=null && dtoTurma.getAno()!=null && dtoTurma.getSemestre()!=null){
				colecao = model.buscarListaDaTurma(dtoTurma);
			}else{
				if(perfil.intValue()!=Dominio.getAluno().intValue())
					colecao=model.buscarTodasListaETurmas();
				else
					colecao=model.buscarTodasListaETurmasDoAlunoNoSemestreCorrente(pessoa.getChavePessoa().toString());
					
			}
			
			if(colecao.size()<1)
				req.setAttribute("mensagemPesquisa", "Nenhuma lista vinculada foi localizada para os parametros informados!");
			
			req.setAttribute("lista",colecao);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisaListaDaTurma.do";
		}
		
		return "/jsp/questao/lista/listarListasDaTurma.jsp";
	}
}
