package questao.acao.lista;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.model.ListaModel;
import slave.Dominio;
import acao.Acao;


public class PesquisarListaQuestoesPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String tituloLista = req.getParameter("tituloLista");
		ListaModel model = new ListaModel(login);
		try{
			Collection colecao = model.buscarListaPorTitulo(tituloLista);
			req.setAttribute("lista",colecao);
			if(colecao.size()<1)
				req.setAttribute("mensagemPesquisa", Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisaListaQuestoes.do";
		}
		
		return "/jsp/questao/lista/listarListaDeQuestoesPopUp.jsp";
	}
}
