package questao.acao.lista;

import java.sql.SQLException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import questao.dto.QuestaoDTO;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;


public class RemoveQuestaoManualmenteNaListaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String quantidadeQuestoes = req.getParameter("quantidadeQuestoes");
		List listaQuestoes = null;
		String idQuestao = req.getParameter("idQuestao");
//		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
//		QuestaoModel model = new QuestaoModel(login);
//		QuestaoDTO dto = null;
		
		try {
			listaQuestoes = recuperaLista(req);
		} catch (SQLException e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/adicionaQuestaoManualmenteNaLista.do";
		}
		
		if(idQuestao!=null && quantidadeQuestoes!=null && listaQuestoes!=null){
//			try {
//				dto = model.buscarQuestao(new Integer(idQuestao));
//			} catch (SQLException e) {
//				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
//				return "/adicionaQuestaoManualmenteNaLista.do";
//			}
			
			QuestaoDTO questaoTemp = null;
			for(int i=0; i<listaQuestoes.size();i++){
				questaoTemp = (QuestaoDTO)listaQuestoes.get(i);
				if(questaoTemp.getIdQuestao().intValue()==Integer.parseInt(idQuestao)){
					listaQuestoes.remove(i);
				}
			}
		}
//		else{
//			req.setAttribute("mensagem","Erro no processamento! Favor contate o administrador!");
//			return "/abrirFiltroBuscaQuestao.do";
//		}
		req.setAttribute("lista", listaQuestoes);
		return "/jsp/questao/lista/editaListaManualmente.jsp";
	}
	
	public List recuperaLista(HttpServletRequest req) throws Exception{
		return VisaoQuestao.recuperaLista(req);
	}
}
