package questao.acao.lista;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import questao.model.ListaModel;
import questao.slave.UtilDate;
import questao.validacao.ValidacaoCamposVincularLista;
import questao.validacao.message.MessageErrorVincularLista;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class VincularListaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorVincularLista met = new MessageErrorVincularLista();

		try{
			ValidacaoCamposVincularLista.validaLista(req,met);
		}catch (Exception e) {
			req.setAttribute("erro",met);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirVincularListaDaTurma.do";
		}
		//***********************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ListaModel model = new ListaModel(login);
		
		TurmaDTO dto = new TurmaDTO();
		
		dto.setCodigoTurma(req.getParameter("codigoTurma"));
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setAno(new Integer(req.getParameter("ano")));
		dto.setSemestre(req.getParameter("semestre"));
		
		String idLista = req.getParameter("idLista");
		String dtLimiteEntrega = req.getParameter("dtLimiteEntrega");
		String horarioLimiteEntrega = req.getParameter("dtLimiteEntrega")+" "+req.getParameter("horarioLimiteEntrega");
		
		try{
			model.cadastrarListaTurma(dto,new Integer(idLista),UtilDate.getData(dtLimiteEntrega),UtilDate.getDataHora24(horarioLimiteEntrega));
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisaListaDaTurma.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisaListaDaTurma.do";
	}
}
