package questao.acao.relatorio;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

import javax.rmi.CORBA.UtilDelegate;
import javax.servlet.http.*;

import questao.dto.*;
import questao.model.RelatorioModel;
import questao.slave.*;
import questao.slave.DominioRelatorio;
import questao.slave.UtilDate;
import questao.validacao.ValidacaoCamposRelatorio;
import questao.validacao.message.MessageErrorRelatorio;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import slave.DominioPeriodo;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;


public class ContinuaFiltroRelatorioAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorRelatorio met = new MessageErrorRelatorio();

		try{ 
			ValidacaoCamposRelatorio.validaRelatorio(req,met);
		}catch (Exception e) {
			req.setAttribute("erro",met);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirFiltroBuscaRelatorio.do";
		}
		//***********************************************************************
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String pesquisaPor = req.getParameter("pesquisaPor");
		RelatorioModel model = new RelatorioModel(login);
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		PessoaDTO pessoa = VisaoQuestao.carregaPessoaPeloPerfil(secao,perfil);
		
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.ALUNO)){
			return continuaFiltroRelatorioAluno(req, model, perfil, pessoa);
		}
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.TURMA)){ 
			return continuaFiltroRelatorioTurma(req, model, perfil, pessoa);
		}
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.DISCIPLINA)){ 
			return continuaFiltroRelatorioDisciplina(req, model, perfil, pessoa);
		}
		return "/jsp/questao/relatorio/filtroBuscaRelatorio.jsp";
		
	}

	private String continuaFiltroRelatorioDisciplina(HttpServletRequest req, RelatorioModel model, Integer perfil, PessoaDTO pessoa) throws SQLException {
		String idDisciplina = req.getParameter("idDisciplina");
		String idConteudo = req.getParameter("idConteudo");
		Integer ano = new Integer(UtilDate.getAnoAtual());
		String dataInicialString = req.getParameter("periodoInicialDisciplina");
		String dataFinalString = req.getParameter("periodoFinalDisciplina");
		
		Date dataInicial = null;
		Date dataFinal = null;
		
		try{
			dataFinal=UtilDate.getData(dataFinalString);
		}catch(ParseException e){
			dataFinal=null;
		}
		
		try{
			dataInicial=UtilDate.getData(dataInicialString);
		}catch(ParseException e){
			dataInicial=null;
		}
		
		String anoString = req.getParameter("anoRespostaDisciplina");
		if(!VisaoQuestao.isStringVazia(anoString))
			ano = new Integer(anoString);
		
		String semestre = req.getParameter("semestreRespostaDisciplina");
		String listaOuQuestao = req.getParameter("listaOuQuestaoDisciplina");
		String idLista = req.getParameter("idListaDisciplina");
		RelatorioDisciplinaDTO dtoRelatorio = null;
		if(perfil.intValue()==Dominio.getMonitor().intValue()){
			try {
				dtoRelatorio = model.buscarRelatorioDisciplinaPorIdDisciplinaPerfilMonitor(new Integer(idDisciplina),idConteudo,ano,semestre,idLista,listaOuQuestao,pessoa.getChavePessoa(),dataInicial,dataFinal);
			} catch (Exception e1) {
				req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
				return "/abrirFiltroBuscaRelatorio.do";
			} 
		}else{
			try {
				dtoRelatorio = model.buscarRelatorioDisciplinaPorIdDisciplina(new Integer(idDisciplina),idConteudo,ano,semestre,idLista,listaOuQuestao,dataInicial,dataFinal);
			} catch (Exception e1) {
				e1.printStackTrace();
				req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
				return "/abrirFiltroBuscaRelatorio.do";
			} 
		}
		if(dtoRelatorio.getNomeDisciplina()==null){
			req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
			return "/abrirFiltroBuscaRelatorio.do";
		}
		req.setAttribute("relatorio",dtoRelatorio);
		return "/jsp/questao/relatorio/relatorioDisciplina.jsp";
	}
	
	private String continuaFiltroRelatorioTurma(HttpServletRequest req, RelatorioModel model, Integer perfil, PessoaDTO pessoa) throws SQLException, ParseException {
		String codigoTurma = req.getParameter("codigoTurma");
		String codigoCurso = req.getParameter("codigoCurso");
		String dataInicialString = req.getParameter("periodoInicialTurma");
		String dataFinalString = req.getParameter("periodoFinalTurma");
		String idDisciplina = req.getParameter("idDisciplina");
		
		Date dataInicial = null;
		Date dataFinal = null;
		
		try{
			dataFinal=UtilDate.getData(dataFinalString);
		}catch(ParseException e){
			dataFinal=null;
		}
		
		try{
			dataInicial=UtilDate.getData(dataInicialString);
		}catch(ParseException e){
			dataInicial=null;
		}
				
		String ano = req.getParameter("anoRespostaTurma");
		if(ano==null || ano.trim().equals(""))
			ano=new Integer(UtilDate.getAnoAtual()).toString();
		String semestre = req.getParameter("semestreRespostaTurma");
		if(semestre==null || semestre.trim().equals(""))
			semestre=DominioSemestre.getValorSemestrePelaData(UtilDate.getDataAtual());
		String listaOuQuestao = req.getParameter("listaOuQuestaoTurma");
		String idLista = req.getParameter("idListaTurma");
		RelatorioTurmaDTO dtoRelatorio = null;
		if(perfil.intValue()==Dominio.getMonitor().intValue()){
			dtoRelatorio = model.buscarRelatorioTurmaPorCodigoDaTurmaPerfilMonitor(codigoTurma,new Integer(codigoCurso),new Integer(idDisciplina),new Integer(ano),semestre,idLista,listaOuQuestao,pessoa.getChavePessoa(),dataInicial,dataFinal);
		}else{
			dtoRelatorio = model.buscarRelatorioTurmaPorCodigoDaTurma(codigoTurma,new Integer(codigoCurso),new Integer(idDisciplina),new Integer(ano),semestre,idLista,listaOuQuestao,dataInicial,dataFinal);
		}
		if(dtoRelatorio.getCodigoTurma()==null){
			req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
			return "/abrirFiltroBuscaRelatorio.do";
		}
		req.setAttribute("relatorio",dtoRelatorio);
		return "/jsp/questao/relatorio/relatorioTurma.jsp";
	}

	private String continuaFiltroRelatorioAluno(HttpServletRequest req, RelatorioModel model, Integer perfil, PessoaDTO pessoa) throws SQLException, ParseException {
		String chaveAluno = req.getParameter("chaveAluno");
		String listaOuQuestao = req.getParameter("listaOuQuestao");
		String idLista = req.getParameter("idLista");
		String dataInicialString = req.getParameter("periodoInicial");
		String dataFinalString = req.getParameter("periodoFinal");
		String idDisciplina = req.getParameter("idDisciplina");
		String idConteudo = req.getParameter("idConteudo");
		String ano = req.getParameter("anoResposta");
		String semestre = req.getParameter("semestreResposta");
		String busca = req.getParameter("busca");
		Date dataInicial = null;
		Date dataFinal = null;
		
		try{
			dataFinal=UtilDate.getData(dataFinalString);
		}catch(ParseException e){
			dataFinal=null;
		}
		
		try{
			dataInicial=UtilDate.getData(dataInicialString);
		}catch(ParseException e){
			dataInicial=null;
		}
		RelatorioAlunoDTO dtoRelatorio = null;
		if(perfil.intValue()==Dominio.getMonitor().intValue()){
			dtoRelatorio = model.buscarRelatorioAlunoPorChaveAlunoPerfilMonitor(new Integer(chaveAluno),idLista,idDisciplina,idConteudo,semestre,ano,listaOuQuestao,pessoa.getChavePessoa(),dataInicial,dataFinal);
		}else{
			dtoRelatorio = model.buscarRelatorioAlunoPorChaveAluno(new Integer(chaveAluno),idLista,idDisciplina,idConteudo,semestre,ano,listaOuQuestao, perfil, busca,dataInicial,dataFinal);
		}
		
		if(dtoRelatorio.getNomeAluno()==null){
			req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
			return "/abrirFiltroBuscaRelatorio.do";
		}
		req.setAttribute("relatorio",dtoRelatorio);
		return "/jsp/questao/relatorio/relatorioAluno.jsp";
	}
}
