package questao.acao.relatorio;

import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;

import javax.servlet.http.*;

import dto.LoginDTO;

import questao.dto.*;
import questao.dto.RelatorioAlunoDTO;
import questao.dto.RelatorioTurmaDTO;
import questao.model.RelatorioModel;
import questao.slave.*;
import slave.Dominio;
import acao.Acao;

public class ExibeRelatorioPDFAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		System.out.println("Entrando na classe 'ExibeRelatorioPDFAcao'");
		HttpSession secao = req.getSession(false);
		Integer perfil = (Integer)secao.getAttribute("perfil");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		secao.setAttribute("contexto","Relatrio");
		secao.setAttribute("execucao","Pesquisar");
		
		File novoArquivo = null;
		String pesquisaPor = req.getParameter("pesquisaPor");
		System.out.println("Pequisa por = "+pesquisaPor);
		RelatorioModel model = new RelatorioModel(login);
		File logo = UtilFile.recuperaArquivo(req,"imgs/logotipo.gif");
		System.out.println("caminho da imagem do pdf = "+logo.getAbsolutePath());
		//Relatorio de Aluno
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.ALUNO)){
			System.out.println("### PESQUISA POR ALUNO OU PESSOAL ###");
			String chaveAluno = req.getParameter("chaveAluno");
			System.out.println("chave aluno = "+chaveAluno);
			String idDisciplina = req.getParameter("idDisciplina");
			System.out.println("idDisciplina = "+idDisciplina);
			String idConteudo = req.getParameter("idConteudo");
			System.out.println("idConteudo = "+ idConteudo);
			String idLista = req.getParameter("idLista");
			System.out.println("idLista = "+idLista);
			String listaOuQuestao = req.getParameter("listaOuQuestao");
			System.out.println("listaOuQuestao = "+listaOuQuestao);
			
			String dataInicialString = req.getParameter("periodoInicial");
			String dataFinalString = req.getParameter("periodoFinal");
			
			Date dataInicial = null;
			Date dataFinal = null;
			
			try{
				dataFinal=UtilDate.getData(dataFinalString);
			}catch(ParseException e){
				dataFinal=null;
			}
			
			try{
				dataInicial=UtilDate.getData(dataInicialString);
			}catch(ParseException e){
				dataInicial=null;
			}
			
			String ano = req.getParameter("anoResposta");
			if(ano==null || ano.trim().equals(""))
				ano=new Integer(UtilDate.getAnoAtual()).toString();
			System.out.println("anoResposta = "+ano);
			
			String semestre = req.getParameter("semestreResposta");
			if(semestre==null || semestre.trim().equals(""))
				semestre=DominioSemestre.getValorSemestrePelaData(UtilDate.getDataAtual());
			System.out.println("semestreResposta = "+semestre);
			
			String busca = req.getParameter("busca");
			System.out.println("busca = "+busca);
			
			System.out.println("Buscando dados no banco...");
			RelatorioAlunoDTO dtoRelatorio = model.buscarRelatorioAlunoPorChaveAluno(new Integer(chaveAluno),idLista,idDisciplina, idConteudo, semestre, ano,listaOuQuestao, perfil, busca, dataInicial, dataFinal);
			System.out.println("Nome do pesquisado  = "+dtoRelatorio.getNomeAluno());
			if(dtoRelatorio.getNomeAluno()==null){
				System.out.println("Setando msg de 'Erro na base de dados'");
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				System.out.println("retornando a tela de filtro de raltorio");
				return "/abrirFiltroBuscaRelatorio.do";
			}
			req.setAttribute("relatorio",dtoRelatorio);
			System.out.println("setando valores no mapa...");
			HashMap mapa = new HashMap();
			mapa.put("logo", logo.getAbsolutePath());
			mapa.put("nomeCurso", dtoRelatorio.getNomeCurso());
			mapa.put("nomeAluno", dtoRelatorio.getNomeAluno());
			mapa.put("nomeProfessor", dtoRelatorio.getNomeProfessor());
			mapa.put("matriculaAluno", dtoRelatorio.getMatriculaAluno());
			mapa.put("dataDoRelatorio", dtoRelatorio.getDataDoRelatorio());
			mapa.put("nomeDisciplina", dtoRelatorio.getNomeDisciplina());
			mapa.put("descricaoConteudo", dtoRelatorio.getDescricaoConteudo());
			mapa.put("dataAtual", UtilDate.getDataPorExtenso(UtilDate.getDataAtual()));
			mapa.put("totalQuestoes", req.getParameter("somaNumeroQuestoes"));
			if(dataInicial!=null)
				mapa.put("dataInicial", UtilDate.getDataComoString(dataInicial));
			if(dataFinal!=null)
				mapa.put("dataFinal", UtilDate.getDataComoString(dataFinal));
			mapa.put("semestre", dtoRelatorio.getSemestre());
			mapa.put("ano", dtoRelatorio.getAno());
			
			System.out.println("iniciando recuperao do novo arquivo pdf...");
			novoArquivo = UtilFile.recuperaArquivo(req, "relatorios/temp/relatorio"+((LoginDTO)req.getSession().getAttribute("loginDTO")).getChavePessoa()+".pdf");
			System.out.println("nome do arquivo = "+novoArquivo.getAbsolutePath());
			
			System.out.println("if(!novoArquivo.isFile()) = "+(!novoArquivo.isFile()));
			if(!novoArquivo.isFile())
				novoArquivo.createNewFile();
			
			System.out.println("Recuperando o template do PDF...");
			File template = UtilFile.recuperaArquivo(req, "relatorios/templates/relatorioAluno.jasper");
			System.out.println("template = "+template.getAbsolutePath());

			System.out.println("Iniciando gera pdf...");
			GeradorDeRelatorio.geraPDF(template.getAbsolutePath(),novoArquivo.getAbsolutePath(), dtoRelatorio.getListaDisciplina_Relatorio().iterator(), mapa);
		}
		
		//Relatorio de Turma
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.TURMA)){
			System.out.println("### Pesquisa por turma ###");
			String codigoTurma = req.getParameter("codigoTurma");
			String codigoCurso = req.getParameter("codigoCurso");
			String idDisciplina = req.getParameter("idDisciplina");
			String idLista = req.getParameter("idLista");
			String dataInicialString = req.getParameter("periodoInicialTurma");
			String dataFinalString = req.getParameter("periodoFinalTurma");
			System.out.println("codigoTurma = "+codigoTurma);
			
			Date dataInicial = null;
			Date dataFinal = null;
			
			try{
				dataFinal=UtilDate.getData(dataFinalString);
			}catch(ParseException e){
				dataFinal=null;
			}
			
			try{
				dataInicial=UtilDate.getData(dataInicialString);
			}catch(ParseException e){
				dataInicial=null;
			}
			String listaOuQuestao = req.getParameter("listaOuQuestao");
			String ano = req.getParameter("anoResposta");
			if(ano==null || ano.trim().equals(""))
				ano=new Integer(UtilDate.getAnoAtual()).toString();
			String semestre = req.getParameter("semestreResposta");
			if(semestre==null || semestre.trim().equals(""))
				semestre=DominioSemestre.getValorSemestrePelaData(UtilDate.getDataAtual());
			
			System.out.println("Buscando informaes no banco...");
			RelatorioTurmaDTO dtoRelatorio = model.buscarRelatorioTurmaPorCodigoDaTurma(codigoTurma,new Integer(codigoCurso),new Integer(idDisciplina),new Integer(ano),semestre,idLista,listaOuQuestao, dataInicial, dataFinal );
			System.out.println("codigo da turma = "+dtoRelatorio.getCodigoTurma());
			if(dtoRelatorio.getCodigoTurma()==null){
				System.out.println("Setando mensagem de erro na base de dados...");
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				System.out.println("Indo para tela de filtro de relatorio..");
				return "/abrirFiltroBuscaRelatorio.do";
			}
			req.setAttribute("relatorio",dtoRelatorio);
			
			System.out.println("Setando informaes no mapa...");
			HashMap mapa = new HashMap();
			mapa.put("logo", logo.getAbsolutePath());
			mapa.put("nomeCurso", dtoRelatorio.getNomeCurso());
			mapa.put("codigoTurma", dtoRelatorio.getCodigoTurma());
			mapa.put("semestre", dtoRelatorio.getSemestre());
			mapa.put("dataDoRelatorio", dtoRelatorio.getDataDoRelatorio());
			mapa.put("nomeDisciplina", dtoRelatorio.getNomeDisciplina());
			mapa.put("dataAtual", UtilDate.getDataPorExtenso(UtilDate.getDataAtual()));
			mapa.put("semestre", dtoRelatorio.getSemestre());
			mapa.put("totalQuestoes", req.getParameter("somaNumeroQuestoes"));
			if(dataInicial!=null)
				mapa.put("dataInicial", UtilDate.getDataComoString(dataInicial));
			if(dataFinal!=null)
				mapa.put("dataFinal", UtilDate.getDataComoString(dataFinal));
			mapa.put("nomeProfessor", dtoRelatorio.getNomeProfessor());
			
			System.out.println("recuperando arquivo do pdf...(novo arquivo)");
			novoArquivo = UtilFile.recuperaArquivo(req, "relatorios/temp/relatorio"+((LoginDTO)req.getSession().getAttribute("loginDTO")).getChavePessoa()+".pdf");
			System.out.println("novo arquivo = "+novoArquivo.getAbsolutePath());
			
			System.out.println("if(!novoArquivo.isFile()) = "+(!novoArquivo.isFile()));
			if(!novoArquivo.isFile())
				novoArquivo.createNewFile();
			
			System.out.println("recuperando template...");
			File template = UtilFile.recuperaArquivo(req, "relatorios/templates/relatorioTurma.jasper");
			System.out.println("template = "+template.getAbsolutePath());
			
			System.out.println("gerando pdf...");
			GeradorDeRelatorio.geraPDF(template.getAbsolutePath(),novoArquivo.getAbsolutePath(), dtoRelatorio.getListaDisciplina_Relatorio().iterator(), mapa);
		}
		
//		Relatorio de Disciplina
		if(pesquisaPor!=null && pesquisaPor.equals(DominioRelatorio.DISCIPLINA)){
			System.out.println("### Pesquisa por Disciplina ###");
			
			String idDisciplina = req.getParameter("idDisciplina");
			String idConteudo = req.getParameter("idConteudo");
			String idLista = req.getParameter("idLista");
			String dataInicialString = req.getParameter("periodoInicialDisciplina");
			String dataFinalString = req.getParameter("periodoFinalDisciplina");
			System.out.println("idDisciplina = "+idDisciplina);
			
			Date dataInicial = null;
			Date dataFinal = null;
			
			try{
				dataFinal=UtilDate.getData(dataFinalString);
			}catch(ParseException e){
				dataFinal=null;
			}
			
			try{
				dataInicial=UtilDate.getData(dataInicialString);
			}catch(ParseException e){
				dataInicial=null;
			}
			String listaOuQuestao = req.getParameter("listaOuQuestao");
			String ano = req.getParameter("anoResposta");
			if(ano==null || ano.trim().equals(""))
				ano=new Integer(UtilDate.getAnoAtual()).toString();
			String semestre = req.getParameter("semestreResposta");
			if(semestre==null || semestre.trim().equals(""))
				semestre=DominioSemestre.getValorSemestrePelaData(UtilDate.getDataAtual());
			
			System.out.println("buscando informaes de disciplina no banco....");
			RelatorioDisciplinaDTO dtoRelatorio = model.buscarRelatorioDisciplinaPorIdDisciplina(new Integer(idDisciplina),idConteudo,new Integer(ano),semestre,idLista,listaOuQuestao, dataInicial, dataFinal );
			
			System.out.println("nome da diusciplina = "+dtoRelatorio.getNomeDisciplina());
			if(dtoRelatorio.getNomeDisciplina()==null){
				System.out.println("setando mensagem de erro na base de dados...");
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				System.out.println("voltando a tela de filtro de relatorio");
				return "/abrirFiltroBuscaRelatorio.do";
			}
			req.setAttribute("relatorio",dtoRelatorio);
			
			System.out.println("setando informaes no mapa");
			HashMap mapa = new HashMap();
			mapa.put("logo", logo.getAbsolutePath());
			mapa.put("nomeCurso", dtoRelatorio.getNomeCurso());
			mapa.put("ano", dtoRelatorio.getAno());
			mapa.put("dataDoRelatorio", dtoRelatorio.getDataDoRelatorio());
			mapa.put("nomeDisciplina", dtoRelatorio.getNomeDisciplina());
			mapa.put("semestre",semestre);
			mapa.put("totalQuestoes", req.getParameter("somaNumeroQuestoes"));
			if(dataInicial!=null)
				mapa.put("dataInicial", UtilDate.getDataComoString(dataInicial));
			if(dataFinal!=null)
				mapa.put("dataFinal", UtilDate.getDataComoString(dataFinal));
			mapa.put("dataAtual", UtilDate.getDataPorExtenso(UtilDate.getDataAtual()));
			
			System.out.println("recuperando o arquivo do pdf...novo arquivo");
			novoArquivo = UtilFile.recuperaArquivo(req, "relatorios/temp/relatorio"+((LoginDTO)req.getSession().getAttribute("loginDTO")).getChavePessoa()+".pdf");
			System.out.println("novo arquivo = "+novoArquivo);
			
			System.out.println("if(!novoArquivo.isFile()) = "+(!novoArquivo.isFile()));
			if(!novoArquivo.isFile())
				novoArquivo.createNewFile();
			
			System.out.println("recuperando o template...");
			File template = UtilFile.recuperaArquivo(req, "relatorios/templates/relatorioDisciplina.jasper");
			System.out.println("template = "+template.getAbsolutePath());
			
			System.out.println("gerando pdf...");
			GeradorDeRelatorio.geraPDF(template.getAbsolutePath(),novoArquivo.getAbsolutePath(), dtoRelatorio.getListaDisciplina_Relatorio().iterator(), mapa);
		}
		
		if(novoArquivo==null){
			System.out.println("if(novoArquivo==null) = true");
			System.out.println("setando mensagem de erro na base de dados pelo arquivo ser nulo");
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirFiltroBuscaRelatorio.do";
		}
		
		System.out.println("'nomeArquivoPDF' para exibio na outra pagina = "+req.getContextPath()+"/relatorios/temp/"+novoArquivo.getName());
		req.setAttribute("nomeArquivoPDF",req.getContextPath()+"/relatorios/temp/"+novoArquivo.getName());
		System.out.println("colocando a funcao delete on exit");
		System.out.println("dispachando para tela de pdf..");
		return "/jsp/questao/relatorio/exibeRelatorioPDF.jsp";
	}

}
