package questao.acao.resposta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.PessoaModel;
import questao.model.RespostaModel;
import questao.slave.DominioListaOuQuestao;
import questao.validacao.ValidacaoCamposResposta;
import questao.validacao.message.MessageErrorResposta;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;


public class ContinuaFiltroRespostaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorResposta met = new MessageErrorResposta();

		try{ 
			ValidacaoCamposResposta.validaResposta(req,met);
		}catch (Exception e) {
			req.setAttribute("erro",met);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirFiltroBuscaResposta.do";
		}
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		PessoaModel modelPessoa = new PessoaModel(login); 
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		RespostaModel model = new RespostaModel(login);
		PessoaDTO pessoa = VisaoQuestao.carregaPessoaPeloPerfil(secao,perfil);
		Integer chaveAluno = new Integer(req.getParameter("chaveAluno"));
		
		boolean isBuscaDeRespostaAluno = isBuscaDeRespostaAluno(pessoa, chaveAluno);
		if(isBuscaDeRespostaAluno){
			pessoa=modelPessoa.buscarPessoa(chaveAluno);
		}
		
		String listaOuQuestao = req.getParameter("listaOuQuestao");
		String idLista = req.getParameter("idLista");
		String idDisciplina = req.getParameter("idDisciplina");
		String idConteudo = req.getParameter("idConteudo");
		String ano = req.getParameter("anoResposta");
		String semestre = req.getParameter("semestreResposta");
			
		Collection colecao = new ArrayList();
		try{
			

			if(!listaOuQuestao.equals(DominioListaOuQuestao.LISTA)){
				if(!isBuscaDeRespostaAluno)
					colecao = model.buscaRespostasAvulsaDoUsuario(pessoa.getChavePessoa(),idDisciplina,idConteudo,ano,semestre);
				else
					colecao = model.buscaRespostasAbertaAvulsaDoUsuario(pessoa.getChavePessoa(),idDisciplina,idConteudo,ano,semestre);
			}else{
				if(!isBuscaDeRespostaAluno)
					colecao = model.buscaRespostasListaDoUsuario(pessoa.getChavePessoa(),idLista,idDisciplina,idConteudo,ano,semestre);
				else
					colecao = model.buscaRespostasAbertaListaDoUsuario(pessoa.getChavePessoa(),idLista,idDisciplina,idConteudo,ano,semestre);
			}
			
			if(colecao==null || colecao.size()<1){
				req.setAttribute("mensagem",Dominio.getMensagemNenhumItemEncontrado());
				return "/abrirFiltroBuscaResposta.do";
			}
		}catch(SQLException e){
			e.printStackTrace();
		}
		req.setAttribute("erro",met);
		req.setAttribute("respostas",colecao);
		return "/jsp/questao/resposta/filtroBuscaResposta.jsp";
		
	}

	private boolean isBuscaDeRespostaAluno(PessoaDTO pessoa, Integer chaveAluno) {
		return chaveAluno.intValue()!=pessoa.getChavePessoa().intValue();
	}
}
