package questao.acao.resposta;

import java.sql.Time;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.model.RespostaModel;
import questao.slave.DominioListaOuQuestao;
import questao.slave.UtilDate;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;

public class CorrigirRespostaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		RespostaModel model = new RespostaModel(login);

		String correcao = req.getParameter("correcao");
		Integer idQuestao = new Integer(req.getParameter("idQuestao"));
		String idListaString = req.getParameter("idLista");
		Integer idLista = null;
		if(idListaString!=null && !idListaString.equals("")){
			idLista = new Integer(req.getParameter("idLista"));
		}
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		String dtSolucaoString = req.getParameter("dtSolucao");
		String horarioSolucaoString =req.getParameter("horarioSolucao");
		String listaOuQuestao = req.getParameter("listaOuQuestao");
		Date dtSolucao = null;
		Time horarioSolucao = null;
		
		if(!VisaoQuestao.isStringVazia(dtSolucaoString))
			dtSolucao = UtilDate.getData(dtSolucaoString);
		
		if(!VisaoQuestao.isStringVazia(horarioSolucaoString))
			horarioSolucao = UtilDate.getDateComoSqlTime(UtilDate.getDataHora24(UtilDate.getDataComoString(UtilDate.getDataAtual())+" "+horarioSolucaoString));
		
		try{
			if(listaOuQuestao.equalsIgnoreCase(DominioListaOuQuestao.LISTA))
				model.corrigirRespostaLista(correcao, idQuestao, chavePessoa ,idLista);
			else
				model.corrigirRespostaAvulsa(correcao, idQuestao, chavePessoa , dtSolucao, horarioSolucao);
			
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarQuestao.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirFiltroBuscaResposta.do";
	}
}
