package questao.acao.resposta;

import java.sql.Time;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import questao.model.RespostaModel;
import questao.slave.DominioListaOuQuestao;
import questao.slave.UtilDate;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;


public class ExcluirRespostaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		RespostaModel model = new RespostaModel(login);
		Integer idQuestao = new Integer(req.getParameter("idQuestao"));
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		String dtSolucaoString = req.getParameter("dtSolucao");
		String horarioSolucaoString = req.getParameter("horarioSolucao");
		String listaOuQuestao = req.getParameter("listaOuQuestao");
		Date dtSolucao = null;
		Time horarioSolucao = null;
		
		if(!VisaoQuestao.isStringVazia(dtSolucaoString))
			dtSolucao = UtilDate.getData(dtSolucaoString);
		
		if(!VisaoQuestao.isStringVazia(horarioSolucaoString))
			horarioSolucao = UtilDate.getDateComoSqlTime(UtilDate.getDataHora24(UtilDate.getDataComoString(UtilDate.getDataAtual())+" "+horarioSolucaoString));
			
		try{
			if(listaOuQuestao.equals(DominioListaOuQuestao.QUESTAO_AVULSA))
				model.excluirResposta(idQuestao,chavePessoa,dtSolucao,horarioSolucao);
			else
				model.excluirRespostaLista(idQuestao,chavePessoa,dtSolucao,horarioSolucao);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirFiltroBuscaResposta.do";
		}
		
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirFiltroBuscaResposta.do";
	}

}
