package questao.acao.resposta;

import java.sql.Time;
import java.util.Date;

import javax.servlet.http.*;

import questao.model.RespostaModel;
import questao.slave.DominioListaOuQuestao;
import questao.slave.UtilDate;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;


public class MostraExclusaoAlteracaoRespostaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		RespostaModel model = new RespostaModel(login);
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		Integer idQuestao = new Integer(req.getParameter("idQuestao"));
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		String idListaString = req.getParameter("idLista");
		Integer idLista =null;
		if(idListaString!=null){
			idLista = new Integer(idListaString);
		}
		String dtSolucaoString = req.getParameter("dtSolucao");
		String horarioSolucaoString =req.getParameter("horarioSolucao");
		String listaOuQuestao = req.getParameter("listaOuQuestao");
		Date dtSolucao = null;
		Time horarioSolucao = null;
		PessoaDTO pessoa = VisaoQuestao.carregaPessoaPeloPerfil(secao,perfil);
		
		if(!VisaoQuestao.isStringVazia(dtSolucaoString))
			dtSolucao = UtilDate.getData(dtSolucaoString);
		
		if(!VisaoQuestao.isStringVazia(horarioSolucaoString))
			horarioSolucao = UtilDate.getDateComoSqlTime(UtilDate.getDataHora24(UtilDate.getDataComoString(UtilDate.getDataAtual())+" "+horarioSolucaoString));
			
		try{
			if(listaOuQuestao.equals(DominioListaOuQuestao.QUESTAO_AVULSA)){
				req.setAttribute("resposta",model.buscaRespostaAvulsa(idQuestao, pessoa.getChavePessoa(), dtSolucao,horarioSolucao ));
			}else{
				req.setAttribute("resposta",model.buscaRespostaLista_Aberta(idQuestao, chavePessoa,idLista));
			}
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirFiltroBuscaResposta.do";
		}
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR") || req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZARQUESTAOLISTA"))
			return "/jsp/questao/resposta/visualizarResposta.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("correcao"))
			return "/jsp/questao/resposta/corrigirResposta.jsp";
		return "/jsp/questao/resposta/excluirResposta.jsp";
	}
}
