package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ComplementoAbertaDTO;
import dao.DAOBase;

public class ComplementoAbertaDAO extends DAOBase{
	
    private static final String SQL_ALTERARQUESTAOAberta = "update bdqAberta set resposta = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAOAberta = "delete from bdqAberta where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAOAberta = "insert into bdqAberta values (?,?)";
	private static final String SQL_LISTARTODASQUESTOESAberta = "select * from bdqAberta order by idquestao";
	private static final String SQL_BUSCARQUESTAOAberta = "select * from bdqAberta where (idquestao = ?)";
	
	public Collection listarTodosComplementos() throws SQLException{
		Statement stm = this.getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOESAberta);
		Collection col = new ArrayList();
		ComplementoAbertaDTO dto;
		while(rs.next()){
			dto = new ComplementoAbertaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarComplemento(ComplementoAbertaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_CADASTRARQUESTAOAberta);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setString(2,dto.getResposta());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirComplemento(Integer idQuestao) throws SQLException {

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_DELETARQUESTAOAberta);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public ComplementoAbertaDTO buscarComplemento(Integer idQuestao) throws SQLException {
		ComplementoAbertaDTO dto = new ComplementoAbertaDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_BUSCARQUESTAOAberta);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarComplemento(ComplementoAbertaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_ALTERARQUESTAOAberta);
		
		ps.setString(1,dto.getResposta());
		ps.setInt(2,dto.getIdQuestao().intValue());
		
		ps.executeUpdate();
		ps.close();
	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
	public void putDto(ResultSet rs, ComplementoAbertaDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setResposta(rs.getString("resposta"));
	}

}
