package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ComplementoEscolhaDTO;
import dao.DAOBase;

public class ComplementoEscolhaDAO extends DAOBase{
	
    private static final String SQL_ALTERARQUESTAOVouF = "update bdqEscolhas set opcao1 = ?, opcao2 = ?, opcao3 = ?, opcao4 = ?, comentarioCerto = ?, comentarioErrado = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAOMultipla = "delete from bdqEscolhas where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAOVouF = "insert into bdqEscolhas values (?,?,?,?,?,?,?,?)";
	private static final String SQL_LISTARTODASQUESTOESVouF = "select * from bdqEscolhas order by idquestao";
	private static final String SQL_BUSCARQUESTAOVouF = "select * from bdqEscolhas where (idquestao = ?)";
	
	public Collection listarTodosComplementos() throws SQLException{
		Statement stm = this.getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOESVouF);
		Collection col = new ArrayList();
		ComplementoEscolhaDTO dto;
		while(rs.next()){
			dto = new ComplementoEscolhaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarComplemento(ComplementoEscolhaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_CADASTRARQUESTAOVouF);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setString(2,dto.getResposta());
		ps.setString(3,dto.getOpcao1());
		ps.setString(4,dto.getOpcao2());
		ps.setString(5,dto.getOpcao3());
		ps.setString(6,dto.getOpcao4());
		ps.setString(7,dto.getComentarioCerto());
		ps.setString(8,dto.getComentarioErrado());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirComplemento(Integer idQuestao) throws SQLException {

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_DELETARQUESTAOMultipla);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public ComplementoEscolhaDTO buscarComplemento(Integer idQuestao) throws SQLException {
		ComplementoEscolhaDTO dto = new ComplementoEscolhaDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_BUSCARQUESTAOVouF);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarComplemento(ComplementoEscolhaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_ALTERARQUESTAOVouF);
		ps.setString(1,dto.getOpcao1());
		ps.setString(2,dto.getOpcao2());
		ps.setString(3,dto.getOpcao3());
		ps.setString(4,dto.getOpcao4());
		ps.setString(5,dto.getComentarioCerto());
		ps.setString(6,dto.getComentarioErrado());
		ps.setInt(7,dto.getIdQuestao().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
	public void putDto(ResultSet rs, ComplementoEscolhaDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setOpcao1(rs.getString("opcao1"));
		dto.setOpcao2(rs.getString("opcao2"));
		dto.setOpcao3(rs.getString("opcao3"));
		dto.setOpcao4(rs.getString("opcao4"));
		dto.setComentarioCerto(rs.getString("comentarioCerto"));
		dto.setComentarioErrado(rs.getString("comentarioErrado"));
		dto.setResposta(rs.getString("resposta"));
	}

}
