package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ComplementoLacunaDTO;
import dao.DAOBase;

public class ComplementoLacunaDAO extends DAOBase{
	
    private static final String SQL_ALTERARQUESTAOLacuna = "update bdqLacuna set comentariocerto = ?, comentarioerrado = ?, frase = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAOLacuna = "delete from bdqLacuna where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAOLacuna = "insert into bdqLacuna values (?,?,?,?,?,?)";
	private static final String SQL_LISTARTODASQUESTOESVouF = "select * from bdqLacuna order by idquestao";
	private static final String SQL_BUSCARQUESTAOLacuna = "select * from bdqLacuna where (idquestao = ?)";
	
	public Collection listarTodosComplementos() throws SQLException{
		Statement stm = this.getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOESVouF);
		Collection col = new ArrayList();
		ComplementoLacunaDTO dto;
		while(rs.next()){
			dto = new ComplementoLacunaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarComplemento(ComplementoLacunaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_CADASTRARQUESTAOLacuna);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setString(2,dto.getResposta());
		ps.setString(3,dto.getFrase());
		ps.setString(4,dto.getComentarioCerto());
		ps.setString(5,dto.getComentarioErrado());
		ps.setString(6,dto.getRespostaAlternativa());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirComplemento(Integer idQuestao) throws SQLException {

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_DELETARQUESTAOLacuna);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public ComplementoLacunaDTO buscarComplemento(Integer idQuestao) throws SQLException {
		ComplementoLacunaDTO dto = new ComplementoLacunaDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_BUSCARQUESTAOLacuna);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarComplemento(ComplementoLacunaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_ALTERARQUESTAOLacuna);
		
		ps.setString(1,dto.getComentarioCerto());
		ps.setString(2,dto.getComentarioErrado());
		ps.setString(3,dto.getFrase());
		ps.setInt(4,dto.getIdQuestao().intValue());
		
		ps.executeUpdate();
		ps.close();
	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
	public void putDto(ResultSet rs, ComplementoLacunaDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setComentarioCerto(rs.getString("comentarioCerto"));
		dto.setComentarioErrado(rs.getString("comentarioErrado"));
		dto.setResposta(rs.getString("resposta"));
		dto.setRespostaAlternativa(rs.getString("respostaAlternativa"));
		dto.setFrase(rs.getString("frase"));
	}

}
