package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ComplementoMultiplaDTO;
import dao.DAOBase;

public class ComplementoMultiplaDAO extends DAOBase{
	
    private static final String SQL_ALTERARQUESTAOVouF = "update bdqMultipla set opcao1 = ?, opcao2 = ?, opcao3 = ?, opcao4 = ?, comentario1 = ?, comentario2 = ?, comentario3 = ?, comentario4 = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAOMultipla = "delete from bdqMultipla where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAOVouF = "insert into bdqMultipla values (?,?,?,?,?,?,?,?,?,?)";
	private static final String SQL_LISTARTODASQUESTOESVouF = "select * from bdqMultipla order by idquestao";
	private static final String SQL_BUSCARQUESTAOVouF = "select * from bdqMultipla where (idquestao = ?)";
	
	public Collection listarTodosComplementos() throws SQLException{
		Statement stm = this.getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOESVouF);
		Collection col = new ArrayList();
		ComplementoMultiplaDTO dto;
		while(rs.next()){
			dto = new ComplementoMultiplaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarComplemento(ComplementoMultiplaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_CADASTRARQUESTAOVouF);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setString(2,dto.getResposta());
		ps.setString(3,dto.getOpcao1());
		ps.setString(4,dto.getOpcao2());
		ps.setString(5,dto.getOpcao3());
		ps.setString(6,dto.getOpcao4());
		ps.setString(7,dto.getComentario1());
		ps.setString(8,dto.getComentario2());
		ps.setString(9,dto.getComentario3());
		ps.setString(10,dto.getComentario4());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirComplemento(Integer idQuestao) throws SQLException {

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_DELETARQUESTAOMultipla);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public ComplementoMultiplaDTO buscarComplemento(Integer idQuestao) throws SQLException {
		ComplementoMultiplaDTO dto = new ComplementoMultiplaDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_BUSCARQUESTAOVouF);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarComplemento(ComplementoMultiplaDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_ALTERARQUESTAOVouF);
		ps.setString(1,dto.getOpcao1());
		ps.setString(2,dto.getOpcao2());
		ps.setString(3,dto.getOpcao3());
		ps.setString(4,dto.getOpcao4());
		ps.setString(5,dto.getComentario1());
		ps.setString(6,dto.getComentario2());
		ps.setString(7,dto.getComentario3());
		ps.setString(8,dto.getComentario4());
		ps.setInt(9,dto.getIdQuestao().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
	public void putDto(ResultSet rs, ComplementoMultiplaDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setOpcao1(rs.getString("opcao1"));
		dto.setOpcao2(rs.getString("opcao2"));
		dto.setOpcao3(rs.getString("opcao3"));
		dto.setOpcao4(rs.getString("opcao4"));
		dto.setComentario1(rs.getString("comentario1"));
		dto.setComentario2(rs.getString("comentario2"));
		dto.setComentario3(rs.getString("comentario3"));
		dto.setComentario4(rs.getString("comentario4"));
		dto.setResposta(rs.getString("resposta"));
	}

}
